% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/map_plot.R
\name{map_plot}
\alias{map_plot}
\title{Visualizes regional disaggregrated estimates on a map}
\usage{
map_plot(object, indicator = "all", MSE = FALSE, CV = FALSE,
  map_obj = NULL, map_dom_id = NULL, map_tab = NULL, col = c("white",
  "red4"), scale_points = NULL, return_data = FALSE)
}
\arguments{
\item{object}{an object of type emdi, containing the estimates to be 
visualized.}

\item{indicator}{optional character vector that selects which indicators
shall be returned: (i) all calculated indicators ("all");
(ii) each indicator name: "Mean" "Quantile_10", "Quantile_25", "Median",
"Quantile_75", "Quantile_90", "Head_Count", "Poverty_Gap", "Gini", 
"Quintile_Share" or the function name/s of "custom_indicator/s"; 
(iii) groups of indicators: "Quantiles", "Poverty" or 
"Inequality". Defaults to "all". Note, additional custom indicators can be 
defined as argument for model-based approaches (see also \code{\link{ebp}}) 
and do not appear in groups of indicators even though these might belong to 
one of the groups.}

\item{MSE}{optional logical. If TRUE, the MSE is also visualized.}

\item{CV}{optional logical. If TRUE, the CV is also visualized.}

\item{map_obj}{an \code{SpatialPolygonsDataFrame} object as defined by the
\code{sp} package on which the data should be visualized.}

\item{map_dom_id}{a character string containing the name of a variable in
\code{map_obj} that indicates the domains.}

\item{map_tab}{a \code{data.frame} object with two columns that match the 
domain variable from the census data set (first column) with the domain 
variable in the map_obj (second column). This should only be used if the IDs 
in both objects differ.}

\item{col}{A \code{vector} of length 2 defining the lowest and highest 
color in the plots}

\item{scale_points}{a structure defining the lowest, the mid and the highest 
value of the colorscale. If a numeric vector of length two is given, this scale
will be used for every plot. Alternatively a list defining colors for each 
plot seperatly may be given. Please see the details section and examples for 
this.}

\item{return_data}{if set to true a fortified data frame including the 
map data as well as the chosen indicators is returned. Customized can easily 
be obtained from this data frame via the package \code{ggmap}. Defaults to false}
}
\value{
creates the plots demanded
}
\description{
Function \code{map_plot} creates spatial visualizations of the estimates
obtained by small area estimation methods or direct estimation.
}
\examples{
\dontrun{
# Loading data - population and sample data
data("eusilcA_pop")
data("eusilcA_smp")

# generate emdi object with additional indicators; here via function ebp()
emdi_model <- ebp(fixed = eqIncome ~ gender + eqsize + cash + 
self_empl + unempl_ben + age_ben + surv_ben + sick_ben + dis_ben + rent + 
fam_allow + house_allow + cap_inv + tax_adj, pop_data = eusilcA_pop,
pop_domains = "district", smp_data = eusilcA_smp, smp_domains = "district",
threshold = 11064.82, transformation = "box.cox", L= 50, MSE = TRUE, B = 50, 
custom_indicator = list( my_max = function(y, threshold){max(y)},
my_min = function(y, threshold){min(y)}), na.rm = TRUE, cpus = 1)

# Load shape file
load_shapeaustria()

# Create mapping table such that variables that indicate domains correspond
# in population data and shape file
mapping_table <- data.frame(unique(eusilcA_pop$district), 
unique(shape_austria_dis$NAME_2))

# Create map plot for mean indicator - point and MSE estimates but no CV
map_plot(object = emdi_model, MSE = TRUE, CV = FALSE, 
map_obj = shape_austria_dis, indicator = c("Mean"), map_dom_id = "NAME_2", 
map_tab = mapping_table)
}
}
\seealso{
\code{\link{ebp}}, \code{\link{emdiObject}},
\code{\link[maptools]{readShapePoly}}
}
