% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calibrate.datalogger.R
\name{calibrate.datalogger}
\alias{calibrate.datalogger}
\title{Calibrate data loggers and correct time series of temperatures}
\usage{

  calibrate.datalogger(control.temperatures = stop("Control temperatures is missing"),
  read.temperatures = stop("Read temperatures must be indicated"),
  temperatures.series = NULL, gam = TRUE, se.fit = TRUE)
}
\arguments{
\item{control.temperatures}{The true temperatures during the calibration process}

\item{read.temperatures}{The read temperatures during the calibration process}

\item{temperatures.series}{The temperatures to be converted using calibration}

\item{gam}{Does gam should be used (TRUE) or glm (FALSE).}

\item{se.fit}{Do standard errors are to be returned}
}
\value{
The function will return a corrected time series of temperatures as a vector if se.fit is FALSE or a list if se.fit is TRUE.
}
\description{
Calibrate a time series of temperatures. Use or gam or glm. If
no temperatures.series is given, it will use the read.temperatures.
}
\details{
calibrate.datalogger calibrates data loggers and correct time series of temperatures.
}
\examples{
\dontrun{
library(embryogrowth)
calibrate.datalogger(control.temperatures=20:30, 
                     read.temperatures=(20:30)+rnorm(11))
}
}
\seealso{
Other Data loggers utilities: \code{\link{uncertainty.datalogger}}
}
\author{
Marc Girondot
}
\concept{Data loggers utilities}
