% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pca_truncated.R
\name{step_pca_truncated}
\alias{step_pca_truncated}
\alias{tidy.step_pca_truncated}
\title{Truncated PCA Signal Extraction}
\usage{
step_pca_truncated(
  recipe,
  ...,
  role = "predictor",
  trained = FALSE,
  num_comp = 5,
  options = list(),
  res = NULL,
  columns = NULL,
  prefix = "PC",
  keep_original_cols = FALSE,
  skip = FALSE,
  id = rand_id("pca_truncated")
)
}
\arguments{
\item{recipe}{A recipe object. The step will be added to the
sequence of operations for this recipe.}

\item{...}{One or more selector functions to choose variables
for this step. See \code{\link[recipes:selections]{selections()}} for more details.}

\item{role}{For model terms created by this step, what analysis role should
they be assigned? By default, the new columns created by this step from
the original variables will be used as \emph{predictors} in a model.}

\item{trained}{A logical to indicate if the quantities for
preprocessing have been estimated.}

\item{num_comp}{The number of components to retain as new predictors.
If \code{num_comp} is greater than the number of columns or the number of
possible components, a smaller value will be used. If \code{num_comp = 0}
is set then no transformation is done and selected variables will
stay unchanged, regardless of the value of \code{keep_original_cols}.}

\item{options}{A list of options to the default method for
\code{\link[irlba:prcomp_irlba]{irlba::prcomp_irlba()}}. Argument defaults are set to \code{retx = FALSE},
\code{center = FALSE}, \code{scale. = FALSE}, and \code{tol = NULL}. \strong{Note} that the
argument \code{x} should not be passed here (or at all).}

\item{res}{The \code{\link[irlba:prcomp_irlba]{irlba::prcomp_irlba()}} object is stored here once this
preprocessing step has be trained by \link[recipes:prep]{recipes::prep}.}

\item{columns}{A character string of the selected variable names. This field
is a placeholder and will be populated once \code{\link[recipes:prep]{prep()}} is used.}

\item{prefix}{A character string for the prefix of the resulting new
variables. See notes below.}

\item{keep_original_cols}{A logical to keep the original variables in the
output. Defaults to \code{FALSE}.}

\item{skip}{A logical. Should the step be skipped when the
recipe is baked by \code{\link[recipes:bake]{bake()}}? While all operations are baked
when \code{\link[recipes:prep]{prep()}} is run, some operations may not be able to be
conducted on new data (e.g. processing the outcome variable(s)).
Care should be taken when using \code{skip = TRUE} as it may affect
the computations for subsequent operations.}

\item{id}{A character string that is unique to this step to identify it.}
}
\value{
An updated version of \code{recipe} with the new step added to the
sequence of any existing operations.
}
\description{
\code{step_pca_truncated()} creates a \emph{specification} of a recipe step that will
convert numeric data into one or more principal components. It is truncated
as it only calculates the number of components it is asked instead of all of
them as is done in \code{\link[recipes:step_pca]{recipes::step_pca()}}.
}
\details{
Principal component analysis (PCA) is a transformation of a group of
variables that produces a new set of artificial features or components. These
components are designed to capture the maximum amount of information (i.e.
variance) in the original variables. Also, the components are statistically
independent from one another. This means that they can be used to combat
large inter-variables correlations in a data set.

It is advisable to standardize the variables prior to running PCA. Here, each
variable will be centered and scaled prior to the PCA calculation. This can
be changed using the \code{options} argument or by using \code{\link[recipes:step_center]{recipes::step_center()}} and
\code{\link[recipes:step_scale]{recipes::step_scale()}}.

The argument \code{num_comp} controls the number of components that will be retained
(the original variables that are used to derive the components are removed from
the data). The new components will have names that begin with \code{prefix} and a
sequence of numbers. The variable names are padded with zeros. For example, if
\code{num_comp < 10}, their names will be \code{PC1} - \code{PC9}. If \code{num_comp = 101},
the names would be \code{PC1} - \code{PC101}.
}
\section{Tidying}{
When you \code{\link[recipes:tidy.recipe]{tidy()}} this step two things can happen depending
the \code{type} argument. If \code{type = "coef"} a tibble returned with 4 columns
\code{terms}, \code{value}, \code{component} , and \code{id}:

\describe{
\item{terms}{character, the selectors or variables selected}
\item{value}{numeric, variable loading}
\item{component}{character, principle component}
\item{id}{character, id of this step}
}

If \code{type = "variance"} a tibble returned with 4 columns \code{terms}, \code{value},
\code{component} , and \code{id}:

\describe{
\item{terms}{character, type of variance}
\item{value}{numeric, value of the variance}
\item{component}{integer, principle component}
\item{id}{character, id of this step}
}
}

\section{Tuning Parameters}{
This step has 1 tuning parameters:
\itemize{
\item \code{num_comp}: # Components (type: integer, default: 5)
}
}

\section{Case weights}{


This step performs an unsupervised operation that can utilize case weights.
As a result, case weights are only used with frequency weights. For more
information, see the documentation in \link[recipes:case_weights]{recipes::case_weights} and the examples on
\code{tidymodels.org}.
}

\examples{
rec <- recipe(~., data = mtcars)
pca_trans <- rec \%>\%
  step_normalize(all_numeric()) \%>\%
  step_pca_truncated(all_numeric(), num_comp = 2)
pca_estimates <- prep(pca_trans, training = mtcars)
pca_data <- bake(pca_estimates, mtcars)

rng <- extendrange(c(pca_data$PC1, pca_data$PC2))
plot(pca_data$PC1, pca_data$PC2,
  xlim = rng, ylim = rng
)

tidy(pca_trans, number = 2)
tidy(pca_estimates, number = 2)
}
\references{
Jolliffe, I. T. (2010). \emph{Principal Component Analysis}. Springer.
}
