% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lencode_bayes.R
\name{step_lencode_bayes}
\alias{step_lencode_bayes}
\alias{tidy.step_lencode_bayes}
\title{Supervised Factor Conversions into Linear Functions using Bayesian Likelihood
Encodings}
\usage{
step_lencode_bayes(
  recipe,
  ...,
  role = NA,
  trained = FALSE,
  outcome = NULL,
  options = list(seed = sample.int(10^5, 1)),
  verbose = FALSE,
  mapping = NULL,
  skip = FALSE,
  id = rand_id("lencode_bayes")
)
}
\arguments{
\item{recipe}{A recipe object. The step will be added to the sequence of
operations for this recipe.}

\item{...}{One or more selector functions to choose variables. For
\code{step_lencode_bayes}, this indicates the variables to be encoded into a
numeric format. See \code{\link[recipes:selections]{recipes::selections()}} for more details. For the
\code{tidy} method, these are not currently used.}

\item{role}{Not used by this step since no new variables are created.}

\item{trained}{A logical to indicate if the quantities for preprocessing have
been estimated.}

\item{outcome}{A call to \code{vars} to specify which variable is used as the
outcome in the generalized linear model. Only numeric and two-level factors
are currently supported.}

\item{options}{A list of options to pass to \code{\link[rstanarm:stan_glmer]{rstanarm::stan_glmer()}}.}

\item{verbose}{A logical to control the default printing by
\code{\link[rstanarm:stan_glmer]{rstanarm::stan_glmer()}}.}

\item{mapping}{A list of tibble results that define the encoding. This is
\code{NULL} until the step is trained by \code{\link[recipes:prep]{recipes::prep()}}.}

\item{skip}{A logical. Should the step be skipped when the recipe is baked by
\code{\link[recipes:bake]{recipes::bake()}}? While all operations are baked when \code{\link[recipes:prep]{recipes::prep()}} is
run, some operations may not be able to be conducted on new data (e.g.
processing the outcome variable(s)). Care should be taken when using \code{skip = TRUE} as it may affect the computations for subsequent operations}

\item{id}{A character string that is unique to this step to identify it.}
}
\value{
An updated version of \code{recipe} with the new step added to the
sequence of existing steps (if any). For the \code{tidy} method, a tibble with
columns \code{terms} (the selectors or variables for encoding), \code{level} (the
factor levels), and \code{value} (the encodings).
}
\description{
\code{step_lencode_bayes()} creates a \emph{specification} of a recipe step that will
convert a nominal (i.e. factor) predictor into a single set of scores derived
from a generalized linear model estimated using Bayesian analysis.
}
\details{
For each factor predictor, a generalized linear model is fit to the outcome
and the coefficients are returned as the encoding. These coefficients are on
the linear predictor scale so, for factor outcomes, they are in log-odds
units. The coefficients are created using a no intercept model and, when two
factor outcomes are used, the log-odds reflect the event of interest being
the \emph{first} level of the factor.

For novel levels, a slightly timmed average of the coefficients is returned.

A hierarchical generalized linear model is fit using \code{\link[rstanarm:stan_glmer]{rstanarm::stan_glmer()}}
and no intercept via

\if{html}{\out{<div class="sourceCode">}}\preformatted{  stan_glmer(outcome ~ (1 | predictor), data = data, ...)
}\if{html}{\out{</div>}}

where the \code{...} include the \code{family} argument (automatically set by the step,
unless passed in by \code{options}) as well as any arguments given to the
\code{options} argument to the step. Relevant options include \code{chains}, \code{iter},
\code{cores}, and arguments for the priors (see the links in the References
below). \code{prior_intercept} is the argument that has the most effect on the
amount of shrinkage.
}
\section{Tidying}{
When you \code{\link[recipes:tidy.recipe]{tidy()}} this step, a tibble is returned with
columns \code{level}, \code{value}, \code{terms}, and \code{id}:

\describe{
\item{level}{character, the factor levels}
\item{value}{numeric, the encoding}
\item{terms}{character, the selectors or variables selected}
\item{id}{character, id of this step}
}
}

\section{Case weights}{


This step performs an supervised operation that can utilize case weights.
To use them, see the documentation in \link[recipes:case_weights]{recipes::case_weights} and the examples on
\code{tidymodels.org}.
}

\examples{
\dontshow{if (rlang::is_installed("modeldata")) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
library(recipes)
library(dplyr)
library(modeldata)

data(grants)

set.seed(1)
grants_other <- sample_n(grants_other, 500)
\donttest{
reencoded <- recipe(class ~ sponsor_code, data = grants_other) \%>\%
  step_lencode_bayes(sponsor_code, outcome = vars(class))
}
\dontshow{\}) # examplesIf}
}
\references{
Micci-Barreca D (2001) "A preprocessing scheme for high-cardinality
categorical attributes in classification and prediction problems," ACM SIGKDD
Explorations Newsletter, 3(1), 27-32.

Zumel N and Mount J (2017) "vtreat: a data.frame Processor for Predictive
Modeling," arXiv:1611.09477

"Hierarchical Partial Pooling for Repeated Binary Trials"
\url{https://CRAN.R-project.org/package=rstanarm/vignettes/pooling.html}

"Prior Distributions for \code{rstanarm} Models"
\url{http://mc-stan.org/rstanarm/reference/priors.html}

"Estimating Generalized (Non-)Linear Models with Group-Specific Terms with
\code{rstanarm}" \url{http://mc-stan.org/rstanarm/articles/glmer.html}
}
\concept{preprocessing encoding}
\keyword{datagen}
