% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{plot_mcc_classes_hist}
\alias{plot_mcc_classes_hist}
\title{Plot histogram of the MCC classes}
\usage{
plot_mcc_classes_hist(models.mcc, models.cluster.ids, num.of.mcc.classes)
}
\arguments{
\item{models.mcc}{a numeric vector of Matthews
Correlation Coefficient (MCC) scores, one for each model.
The \emph{names} attribute may hold the models' names (but it is not required).}

\item{models.cluster.ids}{a numeric vector of cluster ids assigned to each
model. It can be the result of using \code{\link[Ckmeans.1d.dp]{Ckmeans.1d.dp}}
with input the models' MCC values (\code{models.mcc}) and the number of clusters
(\code{num.of.mcc.classes}).}

\item{num.of.mcc.classes}{numeric. A positive integer (>2) that signifies the
number of mcc classes (groups) that we should split the models MCC values.}
}
\description{
This function is a wrapper of the \code{\link[Ckmeans.1d.dp]{ahist}} function
for plotting nicely the distribution of the MCC models' values.
}
\examples{
models.mcc = c(-0.04, -0.17, 0.15, -0.24, -0.02 , 0.27, -0.42 , 0.38)
models.cluster.ids = c(2,2,3,1,2,3,1,3)
num.of.mcc.classes = 3
plot_mcc_classes_hist(models.mcc, models.cluster.ids, num.of.mcc.classes)

}
