% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/analysis.R
\name{update_biomarker_files}
\alias{update_biomarker_files}
\title{Update biomarker files for a specific synergy}
\usage{
update_biomarker_files(
  biomarkers.dir,
  drug.comb,
  biomarkers.active.new,
  biomarkers.inhibited.new,
  method = "replace"
)
}
\arguments{
\item{biomarkers.dir}{string. It specifies the full path name of the
directory which holds the biomarker files for the synergistic drug combination
specified in the parameter \code{drug.comb}. The biomarker files must be
formatted as: \emph{\%drug.comb\%_biomarkers_active} or
\emph{\%drug.comb\%_biomarkers_inhibited}, where \%drug.comb\% is the value
of the \code{drug.comb} parameter.}

\item{drug.comb}{string. The drug combination (e.g. "A-B") that will be used
to identify the related biomarker files.}

\item{biomarkers.active.new}{a numeric vector whose \emph{names} attribute
includes the node names of the (newly found) \emph{active biomarkers} for the specified
synergy. The values of the vector are the average activity difference of
each node, derived from a comparison between 2 different groups of models.}

\item{biomarkers.inhibited.new}{a numeric vector whose \emph{names} attribute
includes the node names of the (newly found) \emph{inhibited biomarkers} for the specified
synergy. The values of the vector are the average activity difference of
each node, derived from a comparison between 2 different groups of models.}

\item{method}{string. It specifies the method to use to update the biomarker
files when there are \emph{common nodes} between the 'old' and 'new' biomarkers:
\enumerate{
  \item \code{replace}(DEFAULT): we discard the 'old' biomarkers and keep
  only the 'new' ones
  \item \code{prune.to.common}: we keep only the common biomarkers
  \item \code{extend}: we add to the 'old' set of biomarkers the extra ones
  from the 'new' set that are not non-common to the 'old' ones, extending
  thus the 'old' biomarker set
}}
}
\description{
This function gets the (previously-found or 'old') synergy biomarkers from their
respective files and if any of these files are empty (no 'old' biomarkers
found) or non-existent, the 'new' biomarkers (given as input vector parameters) are
automatically saved. When the 'new' biomarkers \strong{share common nodes}
with the 'old' biomarkers, there exist 3
possible ways to combine the results, given by the \code{method} parameter.
If \strong{no common nodes} exist, no matter the \code{method} selected,
the 'new' biomarkers are added to the 'old' ones.
}
