% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/render.R
\name{render}
\alias{render}
\title{Render Markdown into email}
\usage{
render(
  msg,
  input,
  plain = FALSE,
  include_css = TRUE,
  interpolate = TRUE,
  .open = "{{",
  .close = "}}",
  .envir = NULL
)
}
\arguments{
\item{msg}{A message object.}

\item{input}{The input Markdown file to be rendered or a character vector of Markdown text.}

\item{plain}{Whether to treat the input as plain or R Markdown.}

\item{include_css}{Whether to include rendered CSS.}

\item{interpolate}{Whether or not to interpolate into input using \link[glue]{glue}.}

\item{.open}{The opening delimiter.}

\item{.close}{The closing delimiter.}

\item{.envir}{Environment used for \code{glue} interpolation. Defaults to \code{parent.frame()}.}
}
\value{
A message object.
}
\description{
Render either Plain Markdown or R Markdown directly into the body of an email.
}
\examples{

# Plain Markdown

markdown <- "[This](https://www.google.com) is a link."
filename <- "message.md"

# Render from Markdown in character vector.
msg <- envelope() \%>\% render(markdown, plain = TRUE)

# Create a file containing Markdown
cat(markdown, file = filename)

# Render from Markdown in file.
msg <- envelope() \%>\% render(filename, plain = TRUE)

# Cleanup.
file.remove(filename)

# R Markdown

filename <- "gh-doc.Rmd"

# Create an Rmd document from template.
rmarkdown::draft(
  filename,
  template = "github_document",
  package = "rmarkdown",
  edit = FALSE
)

# Render from Rmd file.
msg <- envelope() \%>\% render(filename)

# Cleanup.
file.remove(filename)
}
