% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/attachment.R
\name{attachment}
\alias{attachment}
\title{Add attachments to a message object}
\usage{
attachment(msg, path, type = NA, cid = NA, disposition = NA)
}
\arguments{
\item{msg}{A message object.}

\item{path}{Path to file.}

\item{type}{MIME type or \cite{NA}, which will result in a guess based on file extension.}

\item{cid}{Content-ID or \code{NA}.}

\item{disposition}{Should the content be displayed inline or as an attachment?}
}
\value{
A message object.
}
\description{
Add attachments to a message object
}
\examples{
library(magrittr)

path_mtcars  <- tempfile(fileext = ".csv")
path_cats    <- tempfile(fileext = ".jpg")
path_scatter <- tempfile(fileext = ".png")

write.csv(mtcars, path_mtcars)

download.file("https://bit.ly/2P4LUO8", path_cats, quiet = TRUE)

png(path_scatter)
plot(1:10)
dev.off()

msg <- envelope() \%>\%
  attachment(path_mtcars) \%>\%
  attachment(path_cats, type = "image/jpeg") \%>\%
  attachment(path_scatter, cid = "scatter")

file.remove(path_cats, path_scatter, path_mtcars)
}
