% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/elo.update.R
\name{elo.update}
\alias{elo.update}
\alias{elo.update.default}
\alias{elo.update.formula}
\title{Elo updates}
\usage{
elo.update(wins.A, ...)

\method{elo.update}{default}(wins.A, elo.A, elo.B, k, ..., adjust.A = 0, adjust.B = 0)

\method{elo.update}{formula}(formula, data, na.action, subset, k = NULL, ...)
}
\arguments{
\item{wins.A}{Numeric vector of wins by team A.}

\item{...}{Other arguments (not in use at this time).}

\item{elo.A}{Numeric vectors of elo scores.}

\item{elo.B}{Numeric vectors of elo scores.}

\item{k}{A constant k-value (or a vector, where appropriate).}

\item{adjust.A}{Numeric vectors to adjust \code{elo.A} and \code{elo.B} by.}

\item{adjust.B}{Numeric vectors to adjust \code{elo.A} and \code{elo.B} by.}

\item{formula}{A formula. See \link[=formula.specials]{the help page for formulas} for details.}

\item{data}{A \code{data.frame} in which to look for objects in \code{formula}.}

\item{na.action}{A function which indicates what should happen when the data contain NAs.}

\item{subset}{An optional vector specifying a subset of observations.}
}
\value{
A vector of Elo updates.
}
\description{
Calculate the update value for a given Elo matchup. This is used in
\code{\link{elo.calc}}, which reports the post-update Elo values. This is vectorized.
}
\examples{
elo.update(c(1, 0), c(1500, 1500), c(1500, 1600), k = 20)

dat <- data.frame(wins.A = c(1, 0), elo.A = c(1500, 1500),
                  elo.B = c(1500, 1600), k = c(20, 20))
elo.update(wins.A ~ elo.A + elo.B + k(k), data = dat)
}
\seealso{
\code{\link{elo.prob}}, \code{\link{elo.calc}},
  \code{elo.model.frame}
}
