% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict.elo.winpct.R
\name{predict.elo.winpct}
\alias{predict.elo.winpct}
\title{Make Predictions on an \code{elo.winpct} Object}
\usage{
\method{predict}{elo.winpct}(object, newdata, ...)
}
\arguments{
\item{object}{An object of class \code{"\link{elo.winpct}"}.}

\item{newdata}{A new dataset containing the same variables as the call
that made \code{object}. If missing, the predicted win probabilities from
\code{object} will be returned.}

\item{...}{Other arguments.}
}
\value{
A vector of win probabilities.
}
\description{
Make Predictions on an \code{elo.winpct} Object
}
\examples{
data(tournament)
t1 <- head(tournament, -3)
t2 <- tail(tournament, 3)
results <- elo.winpct(score(points.Home, points.Visitor) ~ team.Home + team.Visitor, data = t1,
  subset = points.Home != points.Visitor, k = 0.7)
predict(results)
predict(results, newdata = t2)
}
\seealso{
\code{\link{predict.elo.running}}
}
