% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{index_bulk_dataframe}
\alias{index_bulk_dataframe}
\title{Index data frame with Elasticsearch Bulk API}
\usage{
index_bulk_dataframe(rescource, df)
}
\arguments{
\item{rescource}{An \code{elastic_rescource} object that contains the information on the
Elasticsearch cluster, index and document type, where the indexed data will reside. If this does
not already exist, it will be created automatically.}

\item{df}{data.frame whose rows will be indexed as documents in the Elasticsearch cluster.}
}
\description{
Helper function to orchestrate the assembly of the Bulk API upload file, http request to
Elasticsearch and handling any subsequent respose errors. It's primary purpose is to be called
repeatedly on 'chunks' of a data frame that is too bid to be indexed with a single call to the
Bulk API (and hence the split into smaller more manageable chunks).
}
\examples{
\dontrun{
rescource <- elastic("http://localhost:9200", "iris", "data")
index_bulk_dataframe(rescource, iris)
}
}

