% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mtermvectors.R
\name{mtermvectors}
\alias{mtermvectors}
\title{Multi Termvectors}
\usage{
mtermvectors(conn, index = NULL, type = NULL, ids = NULL,
  body = list(), pretty = TRUE, field_statistics = TRUE,
  fields = NULL, offsets = TRUE, parent = NULL, payloads = TRUE,
  positions = TRUE, preference = "random", realtime = TRUE,
  routing = NULL, term_statistics = FALSE, version = NULL,
  version_type = NULL, ...)
}
\arguments{
\item{conn}{an Elasticsearch connection object, see \code{\link[=connect]{connect()}}}

\item{index}{(character) The index in which the document resides.}

\item{type}{(character) The type of the document.}

\item{ids}{(character) One or more document ids}

\item{body}{(character) Define parameters and or supply a document to get
termvectors for}

\item{pretty}{(logical) pretty print. Default: \code{TRUE}}

\item{field_statistics}{(character) Specifies if document count, sum of
document frequencies and sum of total term frequencies should be returned.
Default: \code{TRUE}}

\item{fields}{(character) A comma-separated list of fields to return.}

\item{offsets}{(character) Specifies if term offsets should be returned.
Default: \code{TRUE}}

\item{parent}{(character) Parent id of documents.}

\item{payloads}{(character) Specifies if term payloads should be returned.
Default: \code{TRUE}}

\item{positions}{(character) Specifies if term positions should be returned.
Default: \code{TRUE}}

\item{preference}{(character) Specify the node or shard the operation
should be performed on (Default: \code{random}).}

\item{realtime}{(character) Specifies if request is real-time as opposed to
near-real-time (Default: \code{TRUE}).}

\item{routing}{(character) Specific routing value.}

\item{term_statistics}{(character) Specifies if total term frequency and
document frequency should be returned. Default: \code{FALSE}}

\item{version}{(character) Explicit version number for concurrency control}

\item{version_type}{(character) Specific version type, valid choices are:
'internal', 'external', 'external_gte', 'force'}

\item{...}{Curl args passed on to \link[crul:verb-POST]{crul::verb-POST}}
}
\description{
Multi Termvectors
}
\details{
Multi termvectors API allows to get multiple termvectors based on an
index, type and id.
}
\examples{
\dontrun{
x <- connect()

if (!index_exists(x, 'omdb')) {
  omdb <- system.file("examples", "omdb.json", package = "elastic")
  docs_bulk(x, omdb)
}

# no index or type given
body <- '{
   "docs": [
      {
         "_index": "omdb",
         "_type": "omdb",
         "_id": "AVXdx8Eqg_0Z_tpMDyP_",
         "term_statistics": true
      },
      {
         "_index": "omdb",
         "_type": "omdb",
         "_id": "AVXdx8Eqg_0Z_tpMDyQ1",
         "fields": [
            "Plot"
         ]
      }
   ]
}'
mtermvectors(x, body = body)

# index given, but not type
body <- '{
   "docs": [
      {
         "_type": "omdb",
         "_id": "AVXdx8Eqg_0Z_tpMDyP_",
         "fields": [
            "Plot"
         ],
         "term_statistics": true
      },
      {
         "_type": "omdb",
         "_id": "AVXdx8Eqg_0Z_tpMDyQ1",
         "fields": [
            "Title"
         ]
      }
   ]
}'
mtermvectors(x, 'omdb', body = body)

# index and type given
body <- '{
   "docs": [
      {
         "_id": "AVXdx8Eqg_0Z_tpMDyP_",
         "fields": [
            "Plot"
         ],
         "term_statistics": true
      },
      {
         "_id": "AVXdx8Eqg_0Z_tpMDyQ1"
      }
   ]
}'
mtermvectors(x, 'omdb', 'omdb', body = body)

# index and type given, parameters same, so can simplify
body <- '{
    "ids" : ["AVXdx8Eqg_0Z_tpMDyP_", "AVXdx8Eqg_0Z_tpMDyQ1"],
    "parameters": {
        "fields": [
            "Plot"
        ],
        "term_statistics": true
    }
}'
mtermvectors(x, 'omdb', 'omdb', body = body)

# you can give user provided documents via the 'docs' parameter
## though you have to give index and type that exist in your Elasticsearch 
## instance
body <- '{
   "docs": [
      {
         "_index": "omdb",
         "_type": "omdb",
         "doc" : {
            "Director" : "John Doe",
            "Plot" : "twitter test test test"
         }
      },
      {
         "_index": "omdb",
         "_type": "omdb",
         "doc" : {
           "Director" : "Jane Doe",
           "Plot" : "Another twitter test ..."
         }
      }
   ]
}'
mtermvectors(x, body = body)
}
}
\references{
\url{https://www.elastic.co/guide/en/elasticsearch/reference/current/docs-multi-termvectors.html}
}
\seealso{
\code{\link[=termvectors]{termvectors()}}
}
