% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/alias.R
\name{alias}
\alias{alias}
\alias{alias_get}
\alias{aliases_get}
\alias{alias_exists}
\alias{alias_create}
\alias{alias_delete}
\title{Elasticsearch alias APIs}
\usage{
alias_get(index = NULL, alias = NULL, ignore_unavailable = FALSE, ...)

aliases_get(index = NULL, alias = NULL, ignore_unavailable = FALSE, ...)

alias_exists(index = NULL, alias = NULL, ...)

alias_create(index = NULL, alias, routing = NULL, filter = NULL, ...)

alias_delete(index = NULL, alias, ...)
}
\arguments{
\item{index}{An index name}

\item{alias}{An alias name}

\item{ignore_unavailable}{(logical) What to do if an specified index name
doesn't exist. If set to \code{TRUE} then those indices are ignored.}

\item{...}{Curl args passed on to \code{\link[httr:POST]{httr::POST()}}}

\item{routing}{Ignored for now}

\item{filter}{Ignored for now}
}
\description{
Elasticsearch alias APIs
}
\examples{
\dontrun{
# Create/update an alias
alias_create(index = "plos", alias = "tables")

# Retrieve a specified alias
alias_get(index="plos")
alias_get(alias="tables")
aliases_get()

# Check for alias existence
alias_exists(index = "plos")
alias_exists(alias = "tables")
alias_exists(alias = "adsfasdf")

# Delete an alias
alias_delete(index = "plos", alias = "tables")
alias_exists(alias = "tables")

# Curl options
library("httr")
alias_create(index = "plos", alias = "tables")
aliases_get(alias = "tables", config=verbose())
}
}
\references{
\url{https://www.elastic.co/guide/en/elasticsearch/reference/current/indices-aliases.html}
}
\author{
Scott Chamberlain \href{mailto:myrmecocystus@gmail.com}{myrmecocystus@gmail.com}
}
