% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nodes.R
\name{nodes}
\alias{nodes}
\alias{nodes_hot_threads}
\alias{nodes_info}
\alias{nodes_stats}
\title{Elasticsearch nodes endpoints.}
\usage{
nodes_stats(node = NULL, metric = NULL, raw = FALSE, fields = NULL,
  verbose = TRUE, ...)

nodes_info(node = NULL, metric = NULL, raw = FALSE, verbose = TRUE, ...)

nodes_hot_threads(node = NULL, metric = NULL, threads = 3,
  interval = "500ms", type = NULL, raw = FALSE, verbose = TRUE, ...)
}
\arguments{
\item{node}{The node}

\item{metric}{A metric to get}

\item{raw}{If TRUE (default), data is parsed to list. If FALSE, then raw JSON.}

\item{fields}{You can get information about field data memory usage on node level or on
index level}

\item{verbose}{If TRUE (default) the url call used printed to console}

\item{...}{Curl args passed on to \code{\link[httr]{GET}}}

\item{threads}{(character) Number of hot threads to provide. Default: 3}

\item{interval}{(character) The interval to do the second sampling of threads. Default: 500ms}

\item{type}{(character) The type to sample, defaults to cpu, but supports wait and block to
see hot threads that are in wait or block state.}
}
\description{
Elasticsearch nodes endpoints.
}
\details{
\url{https://www.elastic.co/guide/en/elasticsearch/reference/current/cluster-nodes-stats.html}

By default, all stats are returned. You can limit this by combining any of indices, os, process,
jvm, network, transport, http, fs, breaker and thread_pool. With the metric parameter you can
select zero or more of:

\itemize{
 \item indices Indices stats about size, document count, indexing and deletion times, search
 times, field cache size, merges and flushes
 \item os retrieve information that concern the operating system
 \item fs File system information, data path, free disk space, read/write stats
 \item http HTTP connection information
 \item jvm JVM stats, memory pool information, garbage collection, buffer pools
 \item network TCP information
 \item os Operating system stats, load average, cpu, mem, swap
 \item process Process statistics, memory consumption, cpu usage, open file descriptors
 \item thread_pool Statistics about each thread pool, including current size, queue and rejected
 tasks
 \item transport Transport statistics about sent and received bytes in cluster communication
 \item breaker Statistics about the field data circuit breaker
}

\code{\link{nodes_hot_threads}} returns plain text, so \code{\link{cat}} is used to print
to the console.
}
\examples{
\dontrun{
(out <- nodes_stats())
nodes_stats(node = names(out$nodes))
nodes_stats(metric='get')
nodes_stats(metric='jvm')
nodes_stats(metric=c('os','process'))
nodes_info()
nodes_info(metric='process')
nodes_info(metric='jvm')
nodes_info(metric='http')
nodes_info(metric='network')
nodes_hot_threads()
}
}

