test_that("Check API calls : No VA - 1 curve", {
  resp <- get_rfr_no_va(region = "FR",
                        year = 2018,
                        month = 12)

  expect_equal(nrow(resp$metadata), 1)
  expect_equal(nrow(resp$data), 150)
  expect_equal(resp$data[, 1], c(-0.00333, -0.00275, -0.00177, -0.00046, 0.00099, 0.00238, 0.00372, 0.00499, 0.00618, 0.00726, 0.00822, 0.00909, 0.00987, 0.01054, 0.01105, 0.01143, 0.01173, 0.01202, 0.01235, 0.01275, 0.01322, 0.01376, 0.01434, 0.01494, 0.01555, 0.01617, 0.01678, 0.01738, 0.01797, 0.01854, 0.0191, 0.01964, 0.02016, 0.02066, 0.02115, 0.02162, 0.02207, 0.0225, 0.02292, 0.02332, 0.0237, 0.02407, 0.02443, 0.02477, 0.0251, 0.02542, 0.02573, 0.02602, 0.02631, 0.02658, 0.02685, 0.0271, 0.02735, 0.02759, 0.02782, 0.02804, 0.02825, 0.02846, 0.02866, 0.02885, 0.02904, 0.02923, 0.0294, 0.02957, 0.02974, 0.0299, 0.03006, 0.03021, 0.03036, 0.0305, 0.03064, 0.03078, 0.03091, 0.03104, 0.03116, 0.03129, 0.0314, 0.03152, 0.03163, 0.03174, 0.03185, 0.03196, 0.03206, 0.03216, 0.03226, 0.03235, 0.03245, 0.03254, 0.03263, 0.03271, 0.0328, 0.03288, 0.03296, 0.03304, 0.03312, 0.0332, 0.03327, 0.03335, 0.03342, 0.03349, 0.03356, 0.03363, 0.03369, 0.03376, 0.03382, 0.03388, 0.03395, 0.03401, 0.03407, 0.03412, 0.03418, 0.03424, 0.03429, 0.03435, 0.0344, 0.03445, 0.0345, 0.03456, 0.03461, 0.03465, 0.0347, 0.03475, 0.0348, 0.03484, 0.03489, 0.03493, 0.03498, 0.03502, 0.03506, 0.0351, 0.03514, 0.03518, 0.03522, 0.03526, 0.0353, 0.03534, 0.03538, 0.03541, 0.03545, 0.03549, 0.03552, 0.03556, 0.03559, 0.03563, 0.03566, 0.03569, 0.03573, 0.03576, 0.03579, 0.03582))
})


test_that("Check API calls : No VA - 4 curves (2 different years/months)", {
  resp <- get_rfr_no_va(region = "FR",
                        year = c(2018, 2019),
                        month = c(8, 9))

  expect_equal(nrow(resp$metadata), 4)
  expect_equal(ncol(resp$data), 4)
  expect_equal(nrow(resp$data), 150)
  expect_equal(resp$data[1:3, 1], c(-0.00347, -0.00248, -0.00109))
  expect_equal(resp$data[1:3, 2], c(-0.00342, -0.00207, -0.00032))
  expect_equal(resp$data[1:3, 3], c(-0.00597, -0.00656, -0.00666))
  expect_equal(resp$data[1:3, 4], c(-0.00525, -0.00553, -0.00559))
})



test_that("Check API calls : With VA - 4 curves (2 different years/months)", {
  resp <- get_rfr_with_va(region = "FR",
                          year = c(2018, 2019),
                          month = c(8, 9))

  expect_equal(nrow(resp$metadata), 4)
  expect_equal(ncol(resp$data), 4)
  expect_equal(nrow(resp$data), 150)
  expect_equal(resp$data[1:3, 1], c(-0.00197, -0.00098, 0.00041))
  expect_equal(resp$data[1:3, 2], c(-0.00212, -0.00077, 0.00098))
  expect_equal(resp$data[1:3, 3], c(-0.00497, -0.00556, -0.00566))
  expect_equal(resp$data[1:3, 4], c(-0.00415, -0.00443, -0.00449))
})
