% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ei_preprocessing.R
\name{stdize_votes_all}
\alias{stdize_votes_all}
\title{stdize_votes_all}
\usage{
stdize_votes_all(
  data,
  race_cols,
  cand_cols,
  totals_from = "cand",
  totals_col = NULL,
  max_dev_race = 0.1,
  max_dev_cand = 0.1,
  avg_dev_race = 0.025,
  avg_dev_cand = 0.025,
  new_names = FALSE,
  ignore_devs = FALSE,
  verbose = TRUE,
  diagnostic = FALSE
)
}
\arguments{
\item{data}{A dataframe of election results, where each row represents a
precinct or geographic voting unit}

\item{race_cols}{A character vector of colnames corresponding to turnout
counts of each race/ethnicity group}

\item{cand_cols}{A character vector of colnames corresponding to turnout
counts of voters for each candidate}

\item{totals_from}{A character string, either "cand" or "race" to set whether
totals are computed from candidate turnout or race/ethnicity turnout columns.
Ignored if totals_col provided.}

\item{totals_col}{A character string with the name of the total vote count
column in the data. If null, total votes are computed within the function}

\item{max_dev_race}{A numeric object setting the max allowable deviation of
any one precincts' sum of race columns from totals}

\item{max_dev_cand}{A numeric object setting the max allowable deviation of
any one precincts' sum of candidate columns from totals}

\item{avg_dev_race}{A numeric object setting the max allowable mean deviation
of all precincts' sum of race columns from totals}

\item{avg_dev_cand}{A numeric object setting the max allowable mean deviation
of all precincts' sum of candidate columns from totals}

\item{new_names}{A boolean indicating whether to return cand and race columns
with the same names. If FALSE, names returned with "_prop" added on.}

\item{ignore_devs}{A boolean. When true, columns are standardized ignoring
all deviations from totals}

\item{verbose}{A boolean. When true, function returns progress messages.}

\item{diagnostic}{A boolean. When true, an extra column of booleans is
returned indicating whether each row had a deviation from totals}
}
\value{
A dataframe containing columns for each race and candidate converted
to percentages and a totals column, ready for Ecological Inference
}
\description{
Converts a dataframe with total votes for candidates and total votes
by each racial/ethnic group into proportions that can be used for
Ecological Inference analysis
}
\author{
Ari Decter-Frain
}
