% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ehelp-NOobj.R, R/ehelp-obj.R
\name{help}
\alias{help}
\title{Wrapper Help Function}
\usage{
help(
  topic,
  package = NULL,
  lib.loc = NULL,
  verbose = getOption("verbose"),
  try.all.packages = getOption("help.try.all.packages"),
  help_type = getOption("help_type")
)

help(
  topic,
  package = NULL,
  lib.loc = NULL,
  verbose = getOption("verbose"),
  try.all.packages = getOption("help.try.all.packages"),
  help_type = getOption("help_type")
)
}
\arguments{
\item{topic}{topic/or/function name to search for}

\item{package}{package where to search}

\item{lib.loc}{location of R libraries}

\item{verbose}{for diplaying the filename}

\item{try.all.packages}{attempt to go trough all installed packages}

\item{help_type}{format of the displayed help (text,html, or pdf)}
}
\description{
This function is a wrapper around the R's system help() function.
It allows the user to include docstring styles documentation and
displayed it as help or information to the users using the help()
command.

This function is a wrapper around the R's system help() function.
It allows the user to include docstring styles documentation and
displayed it as help or information to the users using the help()
command.
}
\details{
Parameters are the same as in utils::help, see help(help,package='utils') for further details.

Parameters are the same as in utils::help, see help(help,package='utils') for further details.
}
\examples{
compute3Dveloc <- function(x,y,z,t){
#' @fnName compute3Dveloc
#' this function computes the velocity of an object in a 3D space
#' @param x  vector of positions in the x-axis
#' @param y  vector of positions in the y-axis
#' @param z  vector of positions in the z-axis
#' @param t  time vector corresponding to the position vector

   # number of elements in vectors
   n <- length(t)
   # compute delta_t
   delta_t <- t[2:n]-t[1:n-1]
   # compute delta_x
   delta_x <- x[2:n]-x[1:n-1]
   # compute delta_y
   delta_y <- y[2:n]-y[1:n-1]
   # compute delta_z
   delta_z <- z[2:n]-z[1:n-1]
   # do actual computation of velocity...
   veloc3D <- list(delta_x/delta_t, delta_y/delta_t, delta_z/delta_t)
   # return value
   return(veloc3D)
}

help(compute3Dveloc)

compute3Dveloc <- function(x,y,z,t){
#' @fnName compute3Dveloc
#' this function computes the velocity of an object in a 3D space
#' @param x  vector of positions in the x-axis
#' @param y  vector of positions in the y-axis
#' @param z  vector of positions in the z-axis
#' @param t  time vector corresponding to the position vector

   # number of elements in vectors
   n <- length(t)
   # compute delta_t
   delta_t <- t[2:n]-t[1:n-1]
   # compute delta_x
   delta_x <- x[2:n]-x[1:n-1]
   # compute delta_y
   delta_y <- y[2:n]-y[1:n-1]
   # compute delta_z
   delta_z <- z[2:n]-z[1:n-1]
   # do actual computation of velocity...
   veloc3D <- list(delta_x/delta_t, delta_y/delta_t, delta_z/delta_t)
   # return value
   return(veloc3D)
}

help(compute3Dveloc)

}
