% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/ega.R
\name{getClarkeZones}
\alias{getClarkeZones}
\title{Assign Clarke error grid zones to paired glucose values}
\usage{
getClarkeZones(referenceVals, testVals)
}
\arguments{
\item{referenceVals}{A vector of glucose values obtained via the reference
method.}

\item{testVals}{A vector of glucose values obtained via a non-reference
method (e.g. a new meter). The values in this vector are paired with those
in \code{referenceVals}, so the length should be the same.}
}
\value{
A character vector is returned, with each element being one of
\code{"A"}, \code{"B"}, \code{"C"}, \code{"D"}, or \code{"E"}.
}
\description{
\code{referenceVals} and \code{testVals} are assumed to contain
paired glucose values from a reference method and a test method,
respectively. The discrepancy between the two values is used to place the
pair into a Clarke error grid zone according to the criteria described
in the original paper by Clarke et. al. (see reference below).
}
\examples{
zones <- getClarkeZones(glucose_data$ref, glucose_data$test)

# counts
table(zones)

# percentages
table(zones)/length(zones)*100
}
\references{
Clarke, W. L., D. Cox, L. A. Gonder-Frederick, W. Carter, and S. L. Pohl.
"Evaluating Clinical Accuracy of Systems for Self-Monitoring of Blood
Glucose." Diabetes Care 10, no. 5 (September 1, 1987): 622-28.
}

