% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/convert_between_d_to_r.R
\name{d_to_r}
\alias{d_to_r}
\alias{convert_d_to_r}
\alias{r_to_d}
\alias{convert_r_to_d}
\alias{oddsratio_to_d}
\alias{convert_oddsratio_to_d}
\alias{logoddsratio_to_d}
\alias{convert_logoddsratio_to_d}
\alias{d_to_oddsratio}
\alias{convert_d_to_oddsratio}
\alias{oddsratio_to_r}
\alias{convert_oddsratio_to_r}
\alias{logoddsratio_to_r}
\alias{convert_logoddsratio_to_r}
\alias{r_to_oddsratio}
\alias{convert_r_to_oddsratio}
\title{Convert Between \emph{d}, \emph{r}, and Odds Ratio}
\usage{
d_to_r(d, ...)

r_to_d(r, ...)

oddsratio_to_d(OR, log = FALSE, ...)

logoddsratio_to_d(OR, log = TRUE, ...)

d_to_oddsratio(d, log = FALSE, ...)

oddsratio_to_r(OR, log = FALSE, ...)

logoddsratio_to_r(OR, log = TRUE, ...)

r_to_oddsratio(r, log = FALSE, ...)
}
\arguments{
\item{d}{Standardized difference value (Cohen's d).}

\item{...}{Arguments passed to or from other methods.}

\item{r}{Correlation coefficient r.}

\item{OR}{\emph{Odds ratio} values in vector or data frame.}

\item{log}{Take in or output the log of the ratio (such as in logistic models).}
}
\value{
Converted index.
}
\description{
Enables a conversion between different indices of effect size, such as
standardized difference (Cohen's d), correlation r or (log) odds ratios.
}
\details{
Conversions between \emph{d} and \emph{OR} is done through these formulae:
\itemize{
\item \eqn{d = \frac{\log(OR)\times\sqrt{3}}{\pi}}{d = log(OR) * sqrt(3) / pi}
\item \eqn{log(OR) = d * \frac{\pi}{\sqrt(3)}}{log(OR) = d * pi / sqrt(3)}
}

Converting between \emph{d} and \emph{r} is done through these formulae:
\itemize{
\item \eqn{d = \frac{2 * r}{\sqrt{1 - r^2}}}{d = 2 * r / sqrt(1 - r^2)}
\item \eqn{r = \frac{d}{\sqrt{d^2 + 4}}}{r = d / sqrt(d^2 + 4)}
}

The conversion from \emph{d} to \emph{r} assumes equally sized groups. The resulting
\emph{r} is also called the binomial effect size display (BESD; Rosenthal et al.,
1982).
}
\examples{
r_to_d(0.5)
d_to_oddsratio(1.154701)
oddsratio_to_r(8.120534)

d_to_r(1)
r_to_oddsratio(0.4472136, log = TRUE)
oddsratio_to_d(1.813799, log = TRUE)

}
\references{
\itemize{
\item Sánchez-Meca, J., Marín-Martínez, F., & Chacón-Moscoso, S. (2003).
Effect-size indices for dichotomized outcomes in meta-analysis. Psychological
methods, 8(4), 448.
\item Borenstein, M., Hedges, L. V., Higgins, J. P. T., & Rothstein, H. R.
(2009). Converting among effect sizes. Introduction to meta-analysis, 45-49.
\item Rosenthal, R., & Rubin, D. B. (1982). A simple, general purpose display of
magnitude of experimental effect. Journal of educational psychology, 74(2), 166.
}
}
\seealso{
\code{\link[=cohens_d]{cohens_d()}}

Other convert between effect sizes: 
\code{\link{diff_to_cles}},
\code{\link{eta2_to_f2}()},
\code{\link{odds_to_probs}()},
\code{\link{oddsratio_to_riskratio}()}
}
\concept{convert between effect sizes}
