% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{plot.EffectData}
\alias{plot.EffectData}
\title{Plots "EffectData" Object}
\usage{
\method{plot}{EffectData}(
  x,
  stats = NULL,
  ncol = grDevices::n2mfrow(length(x))[2L],
  byrow = TRUE,
  share_y = c("no", "all", "rows", "cols"),
  ylim = NULL,
  discrete_lines = TRUE,
  continuous_points = FALSE,
  title = "",
  subplot_titles = TRUE,
  ylab = NULL,
  legend_labels = NULL,
  interval = c("no", "ci", "ciw", "sd"),
  ci_level = 0.95,
  colors = getOption("effectplots.colors"),
  fill = getOption("effectplots.fill"),
  alpha = 1,
  bar_height = 1,
  bar_width = 1,
  bar_measure = c("weight", "N"),
  wrap_x = 10,
  rotate_x = 0,
  plotly = getOption("effectplots.plotly"),
  ...
)
}
\arguments{
\item{x}{An object of class "EffectData".}

\item{stats}{Vector of statistics to show. The default \code{NULL} equals either
\code{c("y_mean", "pred_mean", "pd", "ale")}, or \code{"resid_mean"}
(when \code{x} results from \code{\link[=bias]{bias()}}). Only \emph{available} statistics are shown.
Additionally, this argument controls the order used to plot the lines.}

\item{ncol}{Number of columns of the plot layout, by default
\code{grDevices::n2mfrow(length(x))[2L]}. Only relevant for multiple plots.}

\item{byrow}{Should plots be placed by row? Default is \code{TRUE}.
Only for multiple plots.}

\item{share_y}{Should y axis be shared across subplots? The default is "no".
Other choices are "all", "rows", and "cols". Note that this currently does not
take into account error bars/ribbons.
Has no effect if \code{ylim} is passed. Only for multiple plots.}

\item{ylim}{A vector of length 2 with manual y axis limits, or a list thereof.}

\item{discrete_lines}{Show lines for discrete features. Default is \code{TRUE}.}

\item{continuous_points}{Show points for continuous features. Default is \code{FALSE}.}

\item{title}{Overall plot title, by default \code{""} (no title).}

\item{subplot_titles}{Should variable names be shown as subplot titles?
Default is \code{TRUE}. Only for multiple plots.}

\item{ylab}{Label of the y axis. The default \code{NULL} automatically derives
a reasonable name.}

\item{legend_labels}{Vector of legend labels in the same order as the
statistics plotted, or \code{NULL} (default).}

\item{interval}{What intervals should be shown for observed y and residuals? One of
\itemize{
\item "no" (default),
\item "ci": Z confidence intervals using sqrt(N) as standard error of the mean,
\item "ciw": Like "ci", but using sqrt(weight) as standard error of the mean, or
\item "sd": standard deviations.
Ribbons for continuous features, and error bars otherwise.
}}

\item{ci_level}{The nominal level of the Z confidence intervals (only when
\code{error} equals "ci" or "ciw"). The default is 0.95.}

\item{colors}{Vector of line/point colors of sufficient length.
By default, a color blind friendly palette from "ggthemes".
To change globally, set \verb{options(effectplots.colors = new colors)}.}

\item{fill}{Fill color of bars. The default equals "lightgrey".
To change globally, set \verb{options(effectplots.fill = new color)}.}

\item{alpha}{Alpha transparency of lines and points. Default is 1.}

\item{bar_height}{Relative bar height (default 1). Set to 0 for no bars.}

\item{bar_width}{Bar width multiplier (for discrete features). By default 1.}

\item{bar_measure}{What should bars represent? Either "weight" (default) or "N".}

\item{wrap_x}{Should categorical x axis labels be wrapped after this length?
The default is 10. Set to 0 for no wrapping. Vectorized over \code{x}.
Only for "ggplot2" backend.}

\item{rotate_x}{Should categorical xaxis labels be rotated by this angle?
The default is 0 (no rotation). Vectorized over \code{x}. Only for "ggplot2" backend.}

\item{plotly}{Should 'plotly' be used? The default is \code{FALSE} ('ggplot2' with
'patchwork'). Use \code{options(effectplots.plotly = TRUE)} to change globally.}

\item{...}{Passed to \code{patchwork::plot_layout()} or \code{plotly::subplot()}. Typically
not used.}
}
\value{
If a single plot, an object of class  "ggplot" or "plotly".
Otherwise, an object of class "patchwork", or a "plotly" subplot.
}
\description{
Versatile plot function for an "EffectData" object. By default, all calculated
statistics (except "resid_mean") are shown. To select certain statistics,
use the \code{stats} argument. Set \code{plotly = TRUE} for interactive plots. Note that
all statistics are plotted at bin means, except for ALE
(shown at right bin breaks).
}
\examples{
fit <- lm(Sepal.Length ~ ., data = iris)
xvars <- colnames(iris)[-1]
M <- feature_effects(fit, v = xvars, data = iris, y = "Sepal.Length", breaks = 5)
plot(M, share_y = "all")
plot(M, stats = c("pd", "ale"), legend_labels = c("PD", "ALE"))
plot(M, stats = "resid_mean", share_y = "all", interval = "ci")
}
\seealso{
\code{\link[=feature_effects]{feature_effects()}}, \code{\link[=average_observed]{average_observed()}}, \code{\link[=average_predicted]{average_predicted()}},
\code{\link[=partial_dependence]{partial_dependence()}}, \code{\link[=bias]{bias()}}, \code{\link[=ale]{ale()}}
}
