% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/eem_metrics.R
\name{eem_coble_peaks}
\alias{eem_coble_peaks}
\title{Extract fluorescence peaks}
\usage{
eem_coble_peaks(eem, verbose = TRUE)
}
\arguments{
\item{eem}{An object of class \code{eemlist}.}

\item{verbose}{Logical determining if additional messages should be printed.}
}
\value{
An object of class \code{eemlist}.

A data frame containing peaks B, T, A, M and C for each eem. See
  details for more information.
}
\description{
Extract fluorescence peaks
}
\details{
According to Coble (1996), peaks are defined as follow:

  Peak B: ex = 275 nm, em = 310 nm

  Peak T: ex = 275 nm, em = 340 nm

  Peak A: ex = 260 nm, em = 380:460 nm

  Peak M: ex = 312 nm, em = 380:420 nm

  peak C: ex = 350 nm, em = 420:480 nm

  Given that peaks A, M and C are not defined at fix emission wavelength,
  the maximum fluorescence value in the region is extracted.
}
\section{Interpolation}{


  Different excitation and emission wavelenghts are often used to measure
  EEMs. Hence, it is possible to have mismatchs bewteen measured wavelengths
  and wavelenghts used to calculate specific metrics. In these circumstances,
  EEMs are interpolated using the \code{\link{interp2}} function from the
  \code{parcma} library. A message warning the user will be prompted
  if data interpolation is performed.
}
\examples{
file <- system.file("extdata/cary/scans_day_1/", "sample1.csv", package = "eemR")
eem <- eem_read(file)

eem_coble_peaks(eem)

}
\references{
Coble, P. G. (1996). Characterization of marine and terrestrial
  DOM in seawater using excitation-emission matrix spectroscopy. Marine
  Chemistry, 51(4), 325-346.

  \url{http://doi.org/10.1016/0304-4203(95)00062-3}
}
\seealso{
\link[pracma]{interp2}
}

