% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/srtBayes.R
\name{srtBayes}
\alias{srtBayes}
\title{Bayesian Analysis of Simple Randomised Education Trials (SRT) using Bayesian Linear Regression Model with Vague Priors.}
\usage{
srtBayes(formula, intervention, nsim = 10000, data)
}
\arguments{
\item{formula}{The model to be analysed is of the form y~x1+x2+.... Where y is the outcome variable and Xs are the independent variables.}

\item{intervention}{A string variable specifying the "intervention variable" as appearing in the formula and the data. See example below.}

\item{nsim}{number of MCMC iterations per chain. Default is 2000.}

\item{data}{Data frame containing the data to be analysed.}
}
\value{
S3 object; a list consisting of
\itemize{
\item \code{Beta}: Estimates and credible intervals for the variables specified in the model. Use \code{summary.eefAnalytics} to get Rhat and effective sample size for each estimate.
\item \code{ES}: Conditional Hedges' g effect size and its 95\% credible intervals.
\item \code{sigma}: Residual variance.
\item \code{ProbES}: A matrix of Bayesian posterior probabilities such that the observed effect size is greater than or equal to a pre-specified threshold(s).
\item \code{Unconditional}: A list of unconditional effect sizes, sigma2 and ProbES obtained based on residual variance from the unconditional model (model with only the intercept as a fixed effect).
}
}
\description{
\code{srtBayes} performs Bayesian multilevel analysis of Simple Randomised Education Trials (SRT), utilising vague priors
and JAGS language to fit the model.
This can also be used with schools as fixed effects.
}
\examples{
if(interactive()){

data(mstData)

########################################################
## Bayesian analysis of simple randomised trials      ##
########################################################

output <- srtBayes(Posttest~ Intervention+Prettest,
		intervention="Intervention",nsim=10000,data=mstData)

### Fixed effects
beta <- output$Beta
beta

### Effect size
ES1 <- output$ES
ES1

## Covariance matrix
covParm <- output$covParm
covParm

### plot random effects for schools

plot(output)

### plot posterior probability of an effect size to be bigger than a pre-specified threshold

plot(output,group=1)

###########################################################################################
## Bayesian analysis of simple randomised trials using informative priors for treatment  ##
###########################################################################################

### define priors for explanatory variables

my_prior <- normal(location = c(0,6), scale = c(10,1))

### specify the priors for the conditional model only

output2 <- srtBayes(Posttest~ Prettest+Intervention,
                    intervention="Intervention",
                    nsim=2000,data=mstData,
                    condopt=list(prior=my_prior))

### Fixed effects
beta2 <- output2$Beta
beta2

### Effect size
ES2 <- output2$ES
ES2
}
}
