% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sprosr.R
\name{sprosr}
\alias{sprosr}
\title{Semidefinite Programming-based Protein Structure Determination}
\usage{
sprosr(
  seq,
  aco,
  upl,
  hydrogen_omission = 1,
  f = c(10, 10, 10, 10, 10),
  in_max_res = NULL,
  in_min_res = NULL
)
}
\arguments{
\item{seq}{A table containing the amino acid sequence of the protein in CYANA .seq format}

\item{aco}{A table containing the angle constraint information in CYANA .aco format}

\item{upl}{A table containing the distance constraint information in CYANA .upl format}

\item{hydrogen_omission}{Should side-chain hydrogen atoms be omitted? TRUE/FALSE. Default is FALSE}

\item{f}{Vector of length five detailing the multiplicative factors to be used. See details for more.}

\item{in_max_res}{User overwrite of the maximum residue number.}

\item{in_min_res}{User overwrite of the minimum residue number.}
}
\value{
\item{X}{Matrix containing the three dimensional point configuration of the protein structure.}
\item{report}{A list containing the final violations of the protein}
}
\description{
\code{sprosr} compute the three dimensional strucutre of a protein 
molecule using its amino acid sequences using the semidefinite programming-based
protein structure determination (SPROS) method of Ramandi (2011)
}
\details{
The input files requires by sprosr follow the typical CYANA format. Each is a table with the following columns (no headers required).

Sequence File (seq) \cr
column 1: amino acid residue name  \cr
column 2: residue number \cr

Torsion Angle Restraint File (aco)  \cr
column 1: residue number (corresponding to seq file)  \cr
column 2: amino acid residue name  \cr
column 3: angle identifier, one of PHI or PSI  \cr
column 4: the lower limit of the angle specified in column 3  \cr
column 5: the upper limit of the angle specified in column 3  \cr

Distance Restraint File (upl) \cr
column 1: residue number of the first atom (corresponding to seq file) \cr
column 2: amino acid residue name of the first atom \cr
column 3: atom name of the first atom \cr
column 4: residue number of the second atom (corresponding to seq file) \cr
column 5: amino acid residue name of the second atom \cr
column 6: atom name of the second atom \cr
column 7: upper distance limit (in Angstroms) \cr
}
\references{
Ramandi, Babak A., (2011). New Approaches to Protein NMR Automation. PhD Thesis.
https://uwspace.uwaterloo.ca/bitstream/handle/10012/6389/Alipanahi_Ramandi_Babak.pdf;sequence=1
}
