% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pivot.R
\name{split_by}
\alias{split_by}
\alias{count_by}
\title{Split or count the data according to certain factors}
\usage{
split_by(.data, ..., .sep = ":", .remove_empty = TRUE)

count_by(.data, ..., .remove_empty = TRUE)
}
\arguments{
\item{.data}{An edibble table.}

\item{...}{The factors to split or count by. You cannot split by a record
factor or a factor that uniquely indexes the smallest unit in the
design. You cannot also combine treatment and unit factors together.}

\item{.sep}{The separator to use if more than one factor to split by.}

\item{.remove_empty}{Remove empty combinations. Default is TRUE.}
}
\value{
A named list.
}
\description{
This function has a similar result with \code{split()} where
it returns a named list with names corresponding to the
levels of the separating factor (or concatenated strings
if multiple separating factors). The key differences to \code{split()},
are that the splitting factor does not appear in the elements of the
list and only linked factors and their ancestors appear in the output, e.g.
if treatment is applied to wholeplot and subplots are nested within
subplots, then the subplot will not be shown in the output if split by
treatment.
}
\examples{
spd <- takeout(menu_split())
split(spd, spd$trt1)
spd \%>\% split_by(trt1)
spd \%>\% split_by(trt2)
spd \%>\% split_by(mainplot)
spd \%>\% count_by(trt1)

fac <- takeout(menu_factorial(trt = c(2, 2, 2)))
fac \%>\% count_by(where(~is_trt(.x)))

}
\seealso{
\code{\link[=pivot_wider_by]{pivot_wider_by()}}
}
