% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{plot.edbl_design}
\alias{plot.edbl_design}
\alias{plot.edbl_table}
\alias{plot_fct_graph}
\alias{plot_lvl_graph}
\title{Interactive plot of the edibble design}
\usage{
\method{plot}{edbl_design}(
  x,
  which = c("factors", "levels"),
  width = "100\%",
  height = NULL,
  seed = 1,
  title = NULL,
  subtitle = NULL,
  footer = NULL,
  background = "transparent",
  view = c("show-buttons", "hide-buttons", "static"),
  ...
)

\method{plot}{edbl_table}(x, ...)

plot_fct_graph(
  x,
  width = "100\%",
  height = NULL,
  seed = 1,
  title = NULL,
  subtitle = NULL,
  footer = NULL,
  background = "transparent",
  view = c("show-buttons", "hide-buttons", "static"),
  ...
)

plot_lvl_graph(
  x,
  width = "100\%",
  height = NULL,
  seed = 1,
  title = NULL,
  subtitle = NULL,
  footer = NULL,
  background = "transparent",
  view = c("show-buttons", "hide-buttons", "static"),
  ...
)
}
\arguments{
\item{x}{An edibble design.}

\item{which}{A string of either "factors" or "levels".}

\item{width, height}{The width and height of the plot.}

\item{seed}{A seed number so same plot is always generated.}

\item{title, subtitle, footer}{The title, subtitle or footer of the plot.
By default it uses the name from the \code{x} object as the title while rest is empty.
To modify the look of the text, you can pass a character string consisting of valid
for input style value in an HTML object, e.g. "font-size: 18px;font-family:serif;" as a
named vector where the name corresponds to the text to display, e.g. \code{c("Title" = "font-size:20px;")}.}

\item{background}{The background color of the plot. Default is transparent. The input
can be a color name (e.g. "white"), a HEX value ("#FFFFFF"), or rgb/rgba in the format like rgba(0, 0, 0, 0).}

\item{view}{A string of either "show-buttons" (default), "hide-buttons", "static"}

\item{...}{Currently unused.}
}
\value{
A plot.
}
\description{
Interactive plot of the edibble design
}
\examples{
plot(takeout(menu_crd(t = 4, n = 20)))
}
