% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/operator.recombinator.crossover.R
\name{setupCrossoverRecombinator}
\alias{setupCrossoverRecombinator}
\title{Generator of the one-point crossover recombination operator.}
\usage{
setupCrossoverRecombinator(p = 1)
}
\arguments{
\item{p}{[\code{numeric(1)}]\cr
Cross over probability to form an offspring. Default is \code{1}.}
}
\value{
[\code{ecr_recombinator}]
}
\description{
The one-point crossover recombinator is defined for float and binary
representations. Given two real-valued/binary vectors of length n, the
selector samples a random position i between 1 and n-1. In the next step
it creates two children. The first part of the first child contains of the
subvector from position 1 to position i of the first parent, the second part
from position i+1 to n is taken from the second parent. The second child
is build analogously.
If the parents are list of real-valued/binary vectors, the procedure described
above is applied to each element of the list.
}
\seealso{
Other recombinators: \code{\link{setupIntermediateRecombinator}},
  \code{\link{setupNullRecombinator}},
  \code{\link{setupOXRecombinator}},
  \code{\link{setupPMXRecombinator}},
  \code{\link{setupSBXRecombinator}}
}

