% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/optState.R
\name{OptState}
\alias{OptState}
\title{Optimization state.}
\description{
The optimization state of class \code{ecr_opt_state} is a S3 object containing
all the information about the current state of the optimization process. It
is initialized uopn the generation of the initial population right before the
evolutionary loop is started and is updated after after a new generation was
created, i.~e., after each iteration of the EA loop. Internally the object
is an R environment which allows for manipulation in place. By default the
state object contains the following slots:
\describe{
  \item{iter}{The current iteration/generation.}
  \item{time.created}{Time the object was initialized.}
  \item{time.passed}{Time passed since creation.}
  \item{task}{The optimization task (see \code{\link{makeOptimizationTask}}).}
  \item{pas.set}{The parameter set of the objective function at hand (see \code{\link[ParamHelpers]{ParamSet}}).}
  \item{n.evals}{Number of performed objective function evaluations.}
  \item{control}{The \code{ecr_control} control object.}
  \item{population}{The current population.}
  \item{best.param/best.value}{Best parameter and its value (only in single-objective case).}
}
The final optimization state object is returned by the EA (see \code{\link{ecr_result}}).
}

