% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ea.simpleEA.R
\name{simpleEA}
\alias{simpleEA}
\title{Simple (mu + lambda) EA implementation.}
\usage{
simpleEA(task, n.population = 10L, n.offspring = 10L,
  parent.selector = setupSimpleSelector(), mutator = setupGaussMutator(),
  recombinator = setupCrossoverRecombinator(),
  survival.selector = setupTournamentSelector(2L), max.iter = NULL,
  max.evals = NULL, max.time = NULL, ...)
}
\arguments{
\item{task}{[\code{ecr_optimization_task}]\cr
Optimization task. If a \code{smoof_function} is passed it is automatically
converted into a task.}

\item{n.population}{[\code{integer(1)}]\cr
Population size (mu).
Default is 10.}

\item{n.offspring}{[\code{integer(1)}]\cr
Number of offspring (lambda) generated in each generation.
Default is 10.}

\item{parent.selector}{[\code{ecr_selector}]\cr
Selection operator which implements a procedure to copy individuals from a
given population to the mating pool, i. e., allow them to become parents.}

\item{mutator}{[\code{ecr_mutator}]\cr
Mutation operator of type \code{ecr_mutator}.}

\item{recombinator}{[\code{ecr_recombinator}]\cr
Recombination operator of type \code{ecr_recombinator}.}

\item{survival.selector}{[\code{ecr_selector}]\cr
Selection operator which implements a procedurce to extract individuals from
a given set, which should survive and set up the next generation.}

\item{max.iter}{[\code{integer(1)}]\cr
Maximal number of iterations. Default ist \code{100L}.}

\item{max.evals}{[\code{integer(1)}]\cr
Maximal number of iterations/generations. Default is \code{Inf}.}

\item{max.time}{[\code{integer(1)}]\cr
Time budget in seconds. Default ist \code{Inf}.}

\item{...}{[any]\cr
Further arguments passed to \code{\link{setupECRControl}}.}
}
\value{
[\code{ecr_single_objective_result}]
}
\description{
A simple evolutionary (mu + lambda) strategy for the optimization
of real-valued functions.
}
\note{
This helper function hides the regular \pkg{ecr} interface and offers a more
R like interface to a simple evolutionary algorithm which works on real valued
vectors.
}
\keyword{optimize}

