% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ea.oneplusoneGA.R
\name{onePlusOneGA}
\alias{onePlusOneGA}
\title{Simple (1 + 1) Genetic Algorithm.}
\usage{
onePlusOneGA(task, p = NULL, max.iter = NULL, max.evals = NULL,
  max.time = NULL, ...)
}
\arguments{
\item{task}{[\code{ecr_optimization_task}]\cr
Optimization task. If a \code{smoof_function} is passed it is automatically
converted into a task.}

\item{p}{[\code{numeric(1)}]\cr
Mutation probability for bitplip mutation.
Default is \eqn{1/n} where n is the length of the gene.}

\item{max.iter}{[\code{integer(1)}]\cr
Maximal number of iterations. Default ist \code{100L}.}

\item{max.evals}{[\code{integer(1)}]\cr
Maximal number of iterations/generations. Default is \code{Inf}.}

\item{max.time}{[\code{integer(1)}]\cr
Time budget in seconds. Default ist \code{Inf}.}

\item{...}{[any]\cr
Further arguments passed to \code{\link{setupECRControl}}.}
}
\value{
[\code{ecr_single_objective_result}]
}
\description{
The simplest evolutionary algorithm one can imagine, namely the (1+1) EA/GA.
Maintains a population of a single individual x and uses just bitplip mutation
to generate a child y (obviously no recombination takes place), i.e., each gene
of x is flipped with probability \code{p} independently. The best individual
survives.
This algorithm is of particular interest in the theory of evolutionary algorithms
and its performance is well understood for different function families.
A lot of interesting results exist.
}
\note{
This helper function hides the regular \pkg{ecr} interface and offers a more
R like interface to a simple evolutionary algorithm which works on binary valued
vectors.
}
\keyword{optimize}

