% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ecr.package.R
\docType{package}
\name{ecrpackage}
\alias{ecrpackage}
\alias{ecrpackage-package}
\title{ecr: Evolutionary Computing in R}
\description{
The \pkg{ecr} package offers a comprehensive collection of building blocks for
both single- and multi-objective evolutionary algorithms.

\strong{Problems in Optimization}
Practisioners we are frequently faced with optimization problems. Unfortunately
these problems often consist of a variety of undesirable characteristics, e.g.,
nondifferentiability or noisyness. Besides, in particular in engineering, objective
functions are often not given as an analytical formula. Instead a function evaluation
is a run of a numerical simulation or even a physical experiment. Anyhow,
optimization problems at hand are seldom easily tractable and thus well-known
methods from mathematical optimization, e.g., Newton-Method or gradient descent
algorithms, often cannot be appied for solving.

\strong{Evolutionary Optimization}
Evolutionary Algorithms (EAs)
have proven very successful in a wide variety of real-world problems and they
can handle objective functions with one or more of the aforementioned properties
very well. In principle EAs follow a very easy principle which mimicks natural evoluation
due to Darwin: instead of iteratively working
on a single solution an EA generates a multiset of solution canditates, termned
individuals, in the decision space. This multiset forms the initial population.
Consequitively the following steps are
applied until a stopping condition is met: Select a good subset of the individuals
based on some selection criterion to form a socalled mating pool (selection
criteria work randomly and mostly assign higher selection probabilities for
individuals with high fitness, i.e., low fitness values). Then combine
individuals from the mating pool using recombination operators to form new
individuals which are further perturbed by mutation operators. Perform another
selection to choose the next population.

Evolutionary Algorithms with \pkg{ecr}
All evolutionary algorithms are build up of the same evolutionary operators:
After initilizing an initial population, evolutionary operators, i.e., in particular
parental selection, recombination, mutation and survival selection are applied
until a stopping condition is met. This package offers a lot of ready to
use building blocks, which can easily be combined to set up evolutionary
algorithms, visualize results, monitor the optimization progress and compare
different evolutionary operators and/or parametrizations.
}
\seealso{
\code{\link{setupECRControl}}, \code{\link{setupEvolutionaryOperators}},
\code{\link{makeOptimizationTask}}, \code{\link{doTheEvolution}}
}

