% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/transformTrajectories.R
\encoding{UTF-8}
\name{transformTrajectories}
\alias{transformTrajectories}
\alias{smoothTrajectories}
\alias{centerTrajectories}
\title{Transform trajectories}
\usage{
smoothTrajectories(
  x,
  survey_times = NULL,
  kernel_scale = 1,
  fixed_endpoints = TRUE
)

centerTrajectories(x, exclude = integer(0))
}
\arguments{
\item{x}{An object of class \code{\link{trajectories}}.}

\item{survey_times}{A vector indicating the survey time for all surveys (if \code{NULL}, time between consecutive surveys is considered to be one)}

\item{kernel_scale}{Scale of the Gaussian kernel, related to survey times}

\item{fixed_endpoints}{A logical flag to force keeping the location of trajectory endpoints unmodified}

\item{exclude}{An integer vector indicating sites that are excluded from trajectory centroid computation. Note: for objects of class \code{\link{cycles}}, \code{external} are excluded by default.}
}
\value{
A modified object of class \code{\link{trajectories}}, where distance matrix has been transformed.
}
\description{
The following functions are provided to transform trajectories:
\itemize{
\item{Function \code{smoothTrajectories} performs multivariate smoothing on trajectory data using a Gaussian kernel.}
\item{Function \code{centerTrajectories} shifts all trajectories to the center of the multivariate space and returns a modified distance matrix.}
}
}
\details{
Details of calculations are given in De \enc{Cáceres}{Caceres} et al (2019).
Function \code{centerTrajectories} performs centering of trajectories using matrix algebra as explained in Anderson (2017).
}
\references{
De \enc{Cáceres}{Caceres} M, Coll L, Legendre P, Allen RB, Wiser SK, Fortin MJ, Condit R & Hubbell S. (2019). Trajectory analysis in community ecology. Ecological Monographs 89, e01350.

Anderson (2017). Permutational Multivariate Analysis of Variance (PERMANOVA). Wiley StatsRef: Statistics Reference Online. 1-15. Article ID: stat07841.
}
\seealso{
\code{\link{trajectoryPlot}} \code{\link{trajectoryMetrics}}
}
\author{
Miquel De \enc{Cáceres}{Caceres}, CREAF

Nicolas Djeghri, UBO
}
