% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/trajectoryPlots.R
\encoding{UTF-8}
\name{trajectoryplots}
\alias{trajectoryplots}
\alias{trajectoryPCoA}
\alias{trajectoryPlot}
\title{Trajectory plots}
\usage{
trajectoryPCoA(
  d,
  sites,
  surveys = NULL,
  selection = NULL,
  traj.colors = NULL,
  axes = c(1, 2),
  survey.labels = FALSE,
  ...
)

trajectoryPlot(
  x,
  sites,
  surveys = NULL,
  selection = NULL,
  traj.colors = NULL,
  axes = c(1, 2),
  survey.labels = FALSE,
  ...
)
}
\arguments{
\item{d}{A symmetric \code{\link{matrix}} or an object of class \code{\link{dist}} containing the distance values between pairs of ecosystem states (see details).}

\item{sites}{A vector indicating the site corresponding to each ecosystem state.}

\item{surveys}{A vector indicating the survey corresponding to each ecosystem state (only necessary when surveys are not in order).}

\item{selection}{A character vector of sites, a numeric vector of site indices or logical vector of the same length as \code{sites}, indicating a subset of site trajectories to be selected.}

\item{traj.colors}{A vector of colors (one per site). If \code{selection != NULL} the length of the color vector should be equal to the number of sites selected.}

\item{axes}{The pair of principal coordinates to be plotted.}

\item{survey.labels}{A boolean flag to indicate whether surveys should be plotted as text next to arrow endpoints}

\item{...}{Additional parameters for function \code{\link{arrows}}.}

\item{x}{A data.frame or matrix where rows are ecosystem states and columns are coordinates in an arbitrary space}
}
\value{
Function \code{trajectoryPCoA} returns the result of calling \code{\link{cmdscale}}.
}
\description{
Set of plotting functions for Ecological Trajectory Analysis:
}
\details{
\itemize{
\item{Function \code{trajectoryPCoA} performs principal coordinates analysis (\code{\link{cmdscale}}) and draws trajectories in the ordination scatterplot.}
\item{Function \code{trajectoryPlot} Draws trajectories in a scatterplot corresponding to the input coordinates.}
}


Details of calculations are given in De \enc{Cáceres}{Caceres} et al (2019). 
The input distance matrix \code{d} should ideally be metric. That is, all subsets of distance triplets should fulfill the triangle inequality (see function \code{is.metric}). 
All CTA functions that require metricity include a parameter '\code{add}', which by default is TRUE, meaning that whenever the triangle inequality is broken the minimum constant required to fulfill it is added to the three distances.
If such local (an hence, inconsistent across triplets) corrections are not desired, users should find another way modify \code{d} to achieve metricity, such as PCoA, metric MDS or non-metric MDS (see CTA vignette). 
If parameter '\code{add}' is set to FALSE and problems of triangle inequality exist, CTA functions may provide missing values in some cases where they should not.

The resemblance between trajectories is done by adapting concepts and procedures used for the analysis of trajectories in space (i.e. movement data) (Besse et al. 2016).
}
\examples{
#Description of sites and surveys
sites = c(1,1,1,2,2,2)
surveys=c(1,2,3,1,2,3)
  
#Raw data table
xy<-matrix(0, nrow=6, ncol=2)
xy[2,2]<-1
xy[3,2]<-2
xy[4:6,1] <- 0.5
xy[4:6,2] <- xy[1:3,2]
xy[6,1]<-1
  
#Draw trajectories
trajectoryPlot(xy, sites, surveys, 
               traj.colors = c("black","red"), lwd = 2)

  
#Should give the same results if surveys are not in order 
#(here we switch surveys for site 2)
temp = xy[5,]
xy[5,] = xy[6,]
xy[6,] = temp
surveys[5] = 3
surveys[6] = 2
  
trajectoryPlot(xy, sites, surveys, 
               traj.colors = c("black","red"), lwd = 2)   
 
}
\references{
Besse, P., Guillouet, B., Loubes, J.-M. & François, R. (2016). Review and perspective for distance based trajectory clustering. IEEE Trans. Intell. Transp. Syst., 17, 3306–3317.

De \enc{Cáceres}{Caceres} M, Coll L, Legendre P, Allen RB, Wiser SK, Fortin MJ, Condit R & Hubbell S. (2019). Trajectory analysis in community ecology. Ecological Monographs.

Anderson (2017). Permutational Multivariate Analysis of Variance (PERMANOVA). Wiley StatsRef: Statistics Reference Online. 1-15. Article ID: stat07841.
}
\seealso{
\code{\link{trajectorymetrics}}, \code{\link{trajectoryutils}}, \code{\link{cmdscale}}
}
\author{
Miquel De \enc{Cáceres}{Caceres}, CREAF

Anthony Sturbois, Vivarmor nature, Réserve Naturelle nationale de la Baie de Saint-Brieuc
}
