% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create_variable_mapping.R
\name{create_variable_mapping}
\alias{create_variable_mapping}
\title{Create the variable_mapping table}
\usage{
create_variable_mapping(
  observation,
  observation_ancillary = NULL,
  location_ancillary = NULL,
  taxon_ancillary = NULL
)
}
\arguments{
\item{observation}{(tbl_df, tbl, data.frame) The observation table.}

\item{observation_ancillary}{(tbl_df, tbl, data.frame) The optional observation_ancillary table.}

\item{location_ancillary}{(tbl_df, tbl, data.frame) The optional location_ancillary table.}

\item{taxon_ancillary}{(tbl_df, tbl, data.frame) The optional taxon_ancillary table.}
}
\value{
(tbl_df, tbl, data.frame) The variable_mapping table.
}
\description{
Create the variable_mapping table
}
\details{
This function collects specified data tables, extracts unique variable_name values from each, converts into long (attribute-value) form with the table name and variable_name values to the resulting table's "table_name" and "variable_name" columns, respectively. The resulting table's "mapped_system", "mapped_id", and "mapped_label" are filled with \code{NA} and are to be manually filled.
}
\examples{
flat <- ants_L0_flat

# Create inputs to variable_mapping()

observation <- create_observation(
  L0_flat = flat, 
  observation_id = "observation_id", 
  event_id = "event_id", 
  package_id = "package_id",
  location_id = "location_id", 
  datetime = "datetime", 
  taxon_id = "taxon_id", 
  variable_name = "variable_name",
  value = "value",
  unit = "unit")

observation_ancillary <- create_observation_ancillary(
  L0_flat = flat,
  observation_id = "observation_id", 
  variable_name = c("trap.type", "trap.num", "moose.cage"))

location_ancillary <- create_location_ancillary(
  L0_flat = flat,
  location_id = "location_id",
  variable_name = "treatment")

taxon_ancillary <- create_taxon_ancillary(
  L0_flat = flat,
  taxon_id = "taxon_id",
  variable_name = c(
    "subfamily", "hl", "rel", "rll", "colony.size", 
    "feeding.preference", "nest.substrate", "primary.habitat", 
    "secondary.habitat", "seed.disperser", "slavemaker.sp", 
    "behavior", "biogeographic.affinity", "source"),
  unit = c("unit_hl", "unit_rel", "unit_rll"))

# Create variable_mapping table

variable_mapping <- create_variable_mapping(
  observation = observation,
  observation_ancillary = observation_ancillary,
  location_ancillary = location_ancillary, 
  taxon_ancillary = taxon_ancillary)

variable_mapping

}
