% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wf_transfer.R
\name{wf_transfer}
\alias{wf_transfer}
\title{ECMWF data transfer function}
\usage{
wf_transfer(email, url, path = tempdir(), filename = "ecmwf_tmp.nc",
  verbose = TRUE)
}
\arguments{
\item{email}{email address used to sign up for the ECMWF data service and
used to retrieve the token set by \code{\link[ecmwfr]{wf_set_key}}}

\item{url}{url to query}

\item{path}{path were to store the downloaded data}

\item{filename}{filename to use for the downloaded data}

\item{verbose}{show feedback on data transfers}
}
\value{
a netCDF of data on disk as specified by a
\code{\link[ecmwfr]{wf_request}}
}
\description{
Returns the contents of the requested url as a netCDF file downloaded
to disk or the current status of the requested transfer.
}
\examples{

\dontrun{
# set key
wf_set_key(email = "test@mail.com", key = "123")

# request data and grab url and try a transfer
r <- wf_request("test@email.com")
wf_transfer("test@email.com", url = r$href)
}
}
\seealso{
\code{\link[ecmwfr]{wf_set_key}}
\code{\link[ecmwfr]{wf_request}}
}
\keyword{climate,}
\keyword{data}
\keyword{download,}
\keyword{re-analysis}
