% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/echarty.R
\name{ec.data}
\alias{ec.data}
\title{Data helper}
\usage{
ec.data(df, format = "dataset", header = TRUE)
}
\arguments{
\item{df}{Chart data in data.frame format, required.}

\item{format}{A key on how to format the output list \cr \itemize{
\item 'dataset' = list to be used in \href{https://echarts.apache.org/en/option.html#dataset.source}{dataset} (default), or in \href{https://echarts.apache.org/en/option.html#series-scatter.data}{series.data} but without a header. \cr
\item 'values' = list for customized \href{https://echarts.apache.org/en/option.html#series-scatter.data}{series.data} \cr
\item 'names' = named lists useful for named data like \href{https://echarts.apache.org/en/option.html#series-sankey.links}{sankey links}.
}}

\item{header}{Boolean to include the column names header or not, default TRUE.
Set this to FALSE when used in \href{https://echarts.apache.org/en/option.html#series-scatter.data}{series.data}.}
}
\value{
A list for \emph{dataset.source}, \emph{series.data} or a list of named lists.
}
\description{
Make data lists from a data.frame
}
\seealso{
some live \href{https://rpubs.com/echarty/data-models}{code samples}
}
