% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add.R, R/add_.R
\name{e_bar_3d}
\alias{e_bar_3d}
\alias{e_bar_3d_}
\title{Bar 3D}
\usage{
e_bar_3d(e, y, z, bind, coord.system = "cartesian3D", name = NULL,
  rm.x = TRUE, rm.y = TRUE, ...)

e_bar_3d_(e, y, z, bind = NULL, coord.system = "cartesian3D",
  name = NULL, rm.x = TRUE, rm.y = TRUE, ...)
}
\arguments{
\item{e}{An \code{echarts4r} object as returned by \code{\link{e_charts}}.}

\item{y, z}{Coordinates.}

\item{bind}{Binding.}

\item{coord.system}{Coordinate system to use, one of \code{cartesian3D}, \code{geo3D}, \code{globe}.}

\item{name}{name of the serie.}

\item{rm.x, rm.y}{Whether to remove x and y axis, defaults to \code{TRUE}.}

\item{...}{Any other option to pass, check See Also section.}
}
\description{
Add 3D bars
}
\examples{
\dontrun{
url <- paste0("https://ecomfe.github.io/echarts-examples/",
              "public/data-gl/asset/data/population.json")
data <- jsonlite::fromJSON(url)
data <- as.data.frame(data)
names(data) <- c("lon", "lat", "value")

data \%>\% 
  e_charts(lon) \%>\% 
  e_globe(
    environment = e_stars_texture(),
    base.texture = e_globe_texture()
  ) \%>\% 
  e_bar_3d(lat, value, coord.system = "globe") \%>\% 
  e_visual_map()
  
data \%>\% 
  e_charts(lon) \%>\% 
  e_geo_3d() \%>\% 
  e_bar_3d(lat, value, coord.system = "geo3D") \%>\% 
  e_visual_map()
  
v <- LETTERS[1:10]
matrix <- data.frame(
  x = sample(v, 300, replace = TRUE), 
  y = sample(v, 300, replace = TRUE), 
  z1 = rnorm(300, 10, 1),
  z2 = rnorm(300, 10, 1),
  stringsAsFactors = FALSE
) \%>\% 
  dplyr::group_by(x, y) \%>\% 
  dplyr::summarise(
    z1 = sum(z1),
    z2 = sum(z2)
  ) \%>\% 
  dplyr::ungroup() 
  
trans <- list(opacity = 0.4) # transparency
emphasis <- list(itemStyle = list(color = "#313695"))
  
matrix \%>\% 
  e_charts(x) \%>\% 
  e_bar_3d(y, z1, stack = "stack", name = "Serie 1", itemStyle = trans, emphasis = emphasis) \%>\%
  e_bar_3d(y, z2, stack = "stack", name = "Serie 2", itemStyle = trans, emphasis = emphasis) \%>\% 
  e_legend()
}

}
\seealso{
\href{Additional arguments}{http://echarts.baidu.com/option-gl.html#series-bar3D}
}
