% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lamp-simulate1-method.R
\name{lamp.simulate1}
\alias{lamp.simulate1}
\title{Simulate one sequence of lambda process from stable distribution}
\usage{
lamp.simulate1(object, drop = 10, keep.tau = 1)
}
\arguments{
\item{object}{an object of lamp class}

\item{drop}{numeric, number of tau to discard at the end. Default is 10.}

\item{keep.tau}{numeric, 0 to clean up, 1 to return unused tau, 2 to return all tau. Default is 1.}
}
\value{
an object of lamp class with Z, B, N populated
}
\description{
Simulate lambda process from one random sequence representing the stable random walk process.
}
\examples{
lp <- lamp(4, T.inf=8640, rnd.n=100000)
lp1 <- lamp.simulate1(lp)

}
\author{
Stephen H-T. Lihn
}
\keyword{simulation}
