% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ecld-op-Q-method.R
\name{ecld.op_Q}
\alias{ecld.op_Q}
\alias{ecld.op_Q_skew}
\alias{ecld.op_Q_skew_by_k_lm}
\alias{ecld.fixed_point_atm_Q_left}
\alias{ecld.fixed_point_atm_ki}
\alias{ecld.fixed_point_atm_Q_right}
\alias{ecld.fixed_point_shift}
\title{The Q operator in option pricing model}
\usage{
ecld.op_Q(object, ki, otype = "c")

ecld.op_Q_skew(object, ki, dki = 0.1, otype = "c")

ecld.op_Q_skew_by_k_lm(object, k, otype = "c")

ecld.fixed_point_atm_Q_left(object, otype = "c")

ecld.fixed_point_atm_ki(object)

ecld.fixed_point_atm_Q_right(object)

ecld.fixed_point_shift(object, atm_imp_k)
}
\arguments{
\item{object}{an object of ecld class with built-in \eqn{\rho, \epsilon}}

\item{ki}{numeric, a vector of \eqn{\sigma}-normalized log-strike}

\item{otype}{character, specifying option type:
\code{c} (default) or \code{p}.}

\item{dki}{numeric, delta of ki for calculating slope}

\item{k}{numeric, a vector of log-strike}

\item{atm_imp_k}{numeric, the ATM implied log-strike. It is derived from ATM volatility
times sqare root of time to expiration.}
}
\value{
a numeric vector, representing Q or skew of Q.
        For \code{ecld.fixed_point_atm_ki}, it is ATM ki.
        For \code{ecld.fixed_point_shift}, it is the shift.
}
\description{
The Q operator generates the normalized implied volatility \eqn{\sigma_1(k)/\sigma}.
\code{cld.op_Q_skew} calculates the skew in Q space by ki and +/- dki/2.
\code{cld.op_Q_skew_by_k_lm} calculates the skew in Q space by lm on a vector of k.
ki is derived internally from \code{(k-mu-rho)/sigma}.
\code{ecld.fixed_point_atm_Q_left} is the left hand side of fixed point ATM hypothesis.
\code{ecld.fixed_point_atm_Q_right} is the right hand side of fixed point ATM hypothesis,
                                    assuming shift is stored in rho.
\code{ecld.fixed_point_atm_ki} is the ATM ki in fixed point ATM hypothesis.
                               assuming shift is stored in rho.
\code{ecld.fixed_point_shift} is the utility for the standard shift algorithm, -(atm_imp_k - mu).
}
\author{
Stephen H. Lihn
}
\keyword{Q}
