% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ecd-imgf-method.R
\name{ecd.imgf}
\alias{ecd.imgf}
\alias{ecd.mu_D}
\title{Incomplete MGF of ecd}
\usage{
ecd.imgf(object, x = -Inf, t = 1, minus1 = FALSE, unit.sigma = FALSE,
  n.sigma = .ecd.mpfr.N.sigma, verbose = FALSE)

ecd.mu_D(object)
}
\arguments{
\item{object}{an object of ecd class}

\item{x}{a numeric vector of \code{x}, default to \code{-Inf}}

\item{t}{a numeric value for MGF, default to \code{1}}

\item{minus1}{logical, subtracting one from \eqn{e^{tx}}}

\item{unit.sigma}{logical, transforming to unit sigma to achieve greater stability.
Due to the instability of quadpack for \code{ecd.integrate_pdf}, default to \code{TRUE}.
But constructing a new ecd object has significant overhead, be aware of it in performance sensitive program.}

\item{n.sigma}{length-one numeric, specifying the max number of sigma to check for truncation.}

\item{verbose}{logical, display timing information, for debugging purpose.}
}
\value{
The IMGF
}
\description{
Incomplete moment generating function (IMGF) of ecd, integration of \eqn{e^z P(z)} for z from \code{x} to \code{Inf}.
\code{ecd.mu_D} is simply a wrapper around MGF.
}
\examples{
d <- ecd(0, 0, sigma=0.01)
x <- seq(0, 1, by=0.1)
ecd.imgf(d, x)
}
\author{
Stephen H. Lihn
}
\keyword{cdf}
\keyword{option}
