% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ebirdst-ppms.R
\name{ebirdst_ppms}
\alias{ebirdst_ppms}
\alias{plot.ebirdst_ppms}
\title{eBird Status and Trends predictive performance metrics (PPMs)}
\usage{
ebirdst_ppms(path, ext, es_cutoff, pat_cutoff = 1/7)

\method{plot}{ebirdst_ppms}(x, ...)
}
\arguments{
\item{path}{character; directory that the Status and Trends data for a given
species was downloaded to. This path is returned by \code{ebirdst_download()}
or \code{get_species_path()}.}

\item{ext}{\link{ebirdst_extent} object (optional); the spatiotemporal extent over
which to calculate the PPMs.}

\item{es_cutoff}{fraction between 0-1; the ensemble support cutoff to use in
distinguishing zero and non-zero predictions. Optimal ensemble support
cutoff values are calculated for each week during the modeling process and
stored in the data package for each species. \strong{In general, you should not
specify a value for \code{es_cutoff} and instead allow the function to use the
species-specific model-based values.}}

\item{pat_cutoff}{numeric between 0-1; percent above threshold.}

\item{x}{\link{ebirdst_ppms} object; PPMs as calculated by \code{\link[=ebirdst_ppms]{ebirdst_ppms()}}.}

\item{...}{ignored.}
}
\value{
An \code{ebirdst_pppms} object containing a list of three data frames:
\code{binary_ppms}, \code{occ_ppms}, and \code{abd_ppms}. These data frames have 25 rows
corresponding to 25 Monte Carlo iterations each estimating the PPMs using a
spatiotemporal subsample of the test data. Columns correspond to the
different PPMs. \code{binary_ppms} contains binary or range-based PPMs,
\code{occ_ppms} contains within-range occurrence probability PPMs, and
\code{abd_ppms} contains within-range abundance PPMs. In some cases, PPMs may be
missing, either because there isn't a large enough test set within the
spatiotemporal extent or because average occurrence or abundance is too
low. In these cases, try increasing the size of the \link{ebirdst_extent}
object.

\code{plot()} can be called on the returned \code{ebirdst_ppms} object to produce a
boxplot of PPMs in all three categories: Binary Occurrence, Occurrence
Probability, and Abundance.
}
\description{
Calculate a suite of predictive performance metrics (PPMs) for the eBird
Status and Trends model of a given species within a spatiotemporal extent.
}
\details{
During the eBird Status and Trends modeling process, a subset of
observations (the "test data") are held out from model fitting to be used
for evaluating model performance. Model predictions are made for each of
these observations and this function calculates a suite of predictive
performance metrics (PPMs) by comparing the predictions with the observed
count on the eBird checklist.

Three types of PPMs are calculated: binary or range-based PPMs assess the
ability of model to predict range boundaries, occurrence PPMs assess the
occurrence probability predictions, and abundance PPMs assess the predicted
abundance. Both the occurrence and count PPMs are within-range metrics,
meaning the comparison between observations and predictions is only made
within the range where the species occurs.

Prior to calculating PPMs, the test dataset is subsampled spatiotemporally
using \code{\link[=ebirdst_subset]{ebirdst_subset()}}. This process is performed for 25 monte carlo
iterations resulting in 25 estimates of each PPM.
}
\examples{
\dontrun{
# download example data
path <- ebirdst_download("example_data", tifs_only = FALSE)
# or get the path if you already have the data downloaded
path <- get_species_path("example_data")

# define a spatiotemporal extent to calculate ppms over
bb_vec <- c(xmin = -90, xmax = -82, ymin = 41, ymax = 48)
e <- ebirdst_extent(bb_vec, t = c("05-01", "07-31"))

# compute predictive performance metrics
ppms <- ebirdst_ppms(path = path, ext = e)
plot(ppms)
}
}
