% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ebirdst-loading.R
\name{load_fac_map_parameters}
\alias{load_fac_map_parameters}
\title{Load full annual cycle map parameters}
\usage{
load_fac_map_parameters(path)
}
\arguments{
\item{path}{character; directory that the Status and Trends data for a given
species was downloaded to. This path is returned by \code{ebirdst_download()}
or \code{get_species_path()}.}
}
\value{
A list containing elements:
\itemize{
\item \code{custom_projection}: a custom projection optimized for the given species'
full annual cycle
\item \code{fa_extent}: an \code{Extent} object storing the spatial extent of non-zero
data for the given species in the custom projection
\item \code{res}: a numeric vector with 2 elements giving the target resolution of
raster in the custom projection.
\item \code{fa_extent_sinu}: the extent in sinusoidal projection
\item \code{abundance_bins}: abundance bins for the full annual cycle
}
}
\description{
Get the map parameters used on the eBird Status and Trends website to
optimally display the full annual cycle data. This includes bins for the
abundance data, a projection, and an extent to map. The extent is the spatial
extent of non-zero data across the full annual cycle and the projection is
optimized for this extent.
}
\examples{
\donttest{
# download example data
path <- ebirdst_download("example_data", tifs_only = FALSE)
# or get the path if you already have the data downloaded
path <- get_species_path("example_data")

# get map parameters
load_fac_map_parameters(path)
}
}
