% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ebirdst-loading.R
\name{load_test_data_raw}
\alias{load_test_data_raw}
\title{Raw test data loader}
\usage{
load_test_data_raw(path, return_sf = FALSE)
}
\arguments{
\item{path}{character; full path to the directory containing single species
eBird Status and Trends products.}

\item{return_sf}{logical; whether to return an \link{sf} object of spatial points
rather then the default data frame.}
}
\value{
data.frame containing test data, including checklist locations,
observed counts, and predicted mean and associated error for relative
occurrence and abundance.
}
\description{
Internal function used by \code{\link[=load_test_data]{load_test_data()}} to get the full test data for
calculating predictive performance metrics. This file contains the observed
counts and model predicted relative occurrence and abundance values.
}
\examples{
\donttest{
# download example data
sp_path <- ebirdst_download("example_data", tifs_only = FALSE)

# test data
test_data <- ebirdst:::load_test_data_raw(sp_path)
dplyr::glimpse(test_data)
}
}
\keyword{internal}
