% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tobit_sd.R
\name{tobit_sd_mle}
\alias{tobit_sd_mle}
\title{Maximum Likelihood Estimator for a Single Standard Deviation Parameter}
\usage{
tobit_sd_mle(
  L,
  R,
  mu = matrix(mean(L + R)/2, nrow(L), ncol(L)),
  interval = c(1e-04, 100),
  tol = .Machine$double.eps^0.25
)
}
\arguments{
\item{L}{matrix of lower bounds on observations (n x p)}

\item{R}{matrix of upper bounds on observations (n x p)}

\item{mu}{matrix of known means (n x p)}

\item{interval}{a vector containing the end-points of the interval defining
the convex search space (default: \code{c(1e-4, 1e+2)})}

\item{tol}{the desired accuracy}
}
\value{
a list containing estimate (maximum) and log-likelihood (objective)
}
\description{
Use standard numerical optimization methods to maximize the log-likelihood of
the given problem. If all of the data is passed in, this method computes the
global estimate of standard deviation. By passing in a subset of the data,
more specific estimates can be made (ex column-specific standard deviations).
}
\examples{
set.seed(1)
n = 100; p = 5; r = 2
U.true = matrix(stats::rexp(n*r), n, r)
V.true = matrix(sample(x = c(1,4,7),
                       size = p*r, 
                       replace = TRUE, 
                       prob = c(0.7, 0.2, 0.1)), 
                p, r)
TH = tcrossprod(U.true, V.true)
X = TH + matrix(stats::rnorm(n*p, sd = 1), n, p)
ldl <- 0.1 # lower detection limit, known to be non-negative
L <- ifelse(X < ldl, 0, X)
R <- ifelse(X < ldl, ldl, X)
tobit_sd_mle(L, R, mu = TH)
}
