% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getTrendGADS.R
\name{getTrendGADS}
\alias{getTrendGADS}
\title{Get data for trend reports.}
\usage{
getTrendGADS(
  filePaths,
  vSelect = NULL,
  years,
  fast = TRUE,
  tempPath = tempdir(),
  verbose = TRUE
)
}
\arguments{
\item{filePaths}{Character vectors with paths to the \code{eatGADS} db files.}

\item{vSelect}{Variables from all GADS to be selected (as character vector).}

\item{years}{A numeric vector with identical length as \code{filePaths}.}

\item{fast}{Should \code{\link{getGADS_fast}} be used for data loading instead of \code{\link{getGADS}}? Using the default is heavily recommended.}

\item{tempPath}{The directory, in which both GADS will be temporarily stored. Using the default is heavily recommended.}

\item{verbose}{Should the loading process be reported?}
}
\value{
Returns a \code{GADSdat} object.
}
\description{
Extracts variables from multiple \code{eatGADS} data bases.
Data can then be extracted from the \code{GADSdat} object via
\code{\link{extractData}}. For extracting meta data from a data base or a \code{GADSdat} object see \code{\link{extractMeta}}. To speed
up the data loading, \code{\link{getGADS_fast}} is used per default.
}
\details{
This function extracts data from multiple GADS data bases. All data bases have to be created via
\code{\link{createGADS}}. The data bases are joined via \code{rbind()} and a variable \code{year} is added, corresponding to the
argument \code{years}. The \code{GADSdat} object can then further
be used via \code{\link{extractData}}. See \code{\link[eatDB]{createDB}} and \code{\link[eatDB]{dbPull}} for further explanation
of the querying and merging processes.
}
\examples{
# See getGADS vignette


}
