% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dummies2char.R
\name{dummies2char}
\alias{dummies2char}
\title{Transform dummy variables to character variables.}
\usage{
dummies2char(GADSdat, dummies, dummyValues, charNames)
}
\arguments{
\item{GADSdat}{A \code{GADSdat} object.}

\item{dummies}{A character vector with the names of the dummy variables.}

\item{dummyValues}{A vector with the values which the dummy variables represent.}

\item{charNames}{A character vector containing the new variable names.}
}
\value{
Returns a \code{GADSdat}.
}
\description{
Convert a set of dummy variables into a set of character variables.
}
\details{
A set of dummy variables is transformed to an equal number of character variables.
The character variables are aligned to the left and the remaining character variables are set to \code{NA}.
For each new variable the missing codes of the respective dummy variable are reused.
}
\examples{
## create an example GADSdat
dummy_df <- data.frame(d1 = c("eng", "no eng", "eng"),
                      d2 = c("french", "french", "no french"),
                      d3 = c("no ger", "ger", "no ger"),
                      stringsAsFactors = TRUE)
dummy_g <- import_DF(dummy_df)

## transform dummy variables
dummy_g2 <- dummies2char(dummy_g, dummies = c("d1", "d2", "d3"),
                        dummyValues = c("english", "french", "german"),
                        charNames = c("char1", "char2", "char3"))


}
