% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/useSolver.R
\name{useSolver}
\alias{useSolver}
\title{Use a solver for a list of constraints.}
\usage{
useSolver(
  allConstraints,
  nForms,
  itemIDs,
  solver = c("GLPK", "lpSolve", "Gurobi"),
  timeLimit = Inf,
  modelSense = c("min", "max"),
  ...
)
}
\arguments{
\item{allConstraints}{List of constraints.}

\item{nForms}{Number of forms to be created.}

\item{itemIDs}{Character vector of item IDs.}

\item{solver}{A character string indicating the solver to use.}

\item{timeLimit}{The maximal runtime in seconds.}

\item{modelSense}{A character string indicating whether to minimize or
maximize the objective function.}

\item{...}{Additional arguments for the solver.}
}
\value{
A list with the following elements:
\describe{
  \item{\code{solution}}{The object returned by the solver.}
  \item{\code{solver_function}}{The solver function that was called, and can be called with the \code{objects_for_solver}.}
  \item{\code{objects_for_solver}}{A list with the objects that are used in the call.}
}
}
\description{
Use a mathematical programming solver to solve a list for constrains.
}
\details{
Wrapper around the functions of different solvers (\code{gurobi::gurobi(),
lpSolve::lp(), ...} for a list of constraints set up via \code{eatATA}.
\code{Rglpk} is used per default.

Additional arguments can be passed through
\code{...} and vary from solver to solver (see their respective help pages,
\code{\link[lpSolve]{lp}} or \code{\link[Rglpk]{Rglpk_solve_LP}}); for example
time limits can not be set for \code{lpSolve}.
}
\examples{
nForms <- 2
nItems <- 4

# create constraits
target <- itemTargetConstraint(nForms = nForms, nItems = nItems,
  c(1, 0.5, 1.5, 2), targetValue = 2)
noItemOverlap <- itemUsageConstraint(nForms, nItems = nItems, operator = "=")
testLength <- itemsPerFormConstraint(nForms = nForms, nItems = nItems,
  operator = "<=", 2)

# use a solver
result <- useSolver(list(target, noItemOverlap, testLength),
  nForms = nForms, itemIDs = paste0("Item_", 1:4),
  solver = "GLPK")



}
