% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/appendSolution.R
\name{appendSolution}
\alias{appendSolution}
\title{Append a \code{useSolver} output}
\usage{
appendSolution(solverOut, items, idCol)
}
\arguments{
\item{solverOut}{Object created by \code{useSolver} function.}

\item{items}{Original \code{data.frame} containing information on item level.}

\item{idCol}{Column name or column number in \code{items} containing item IDs. These will be used for matching to the solver output.}
}
\value{
A \code{data.frame}.
}
\description{
Append a \code{useSolver} output of a successfully solved optimization problem to the initial item pool \code{data.frame}.
}
\details{
This function merges the initial item pool information in \code{items} to the solver output in \code{solverOut}.
}
\examples{
## Example item pool
items <- data.frame(ID = 1:10,
itemValues = c(-4, -4, -2, -2, -1, -1, 20, 20, 0, 0))

## Test Assembly
usage <- itemUsageConstraint(nForms = 2, operator = "=",
                             targetValue = 1, itemIDs = items$ID)
perForm <- itemsPerFormConstraint(nForms = 2, operator = "=",
                                  targetValue = 5, itemIDs = items$ID)
target <- minimaxConstraint(nForms = 2,
                               itemValues = items$itemValues,
                               targetValue = 0, itemIDs = items$ID)
sol <- useSolver(allConstraints = list(usage, perForm, target),
                                  solver = "lpSolve")

## Append Solution to existing item information
out <- appendSolution(sol, items = items, idCol = 1)

}
