% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/runfolder.R
\name{runfolder}
\alias{runfolder}
\title{Run Folder}
\usage{
runfolder(path, recursive = FALSE, is.local = TRUE, check.fn = NULL,
  run.files = NULL, verbose = TRUE, edit.on.err = TRUE,
  pattern = "[.][Rr]$")
}
\arguments{
\item{path}{Folder to run.}

\item{recursive}{Run all folder children also.}

\item{is.local}{Code is running on a local machine, not a Shiny server. Helpful for skipping items that can be problematic on the server. In this case, printing to the log.}

\item{check.fn}{Function to run after reach file is read-in.}

\item{run.files}{Optionally pass the list of files to run. Otherwise, list.files will be run on the folder.}

\item{verbose}{Print names of files and run-time via cat.}

\item{edit.on.err}{Open the running file if an error occurs.}

\item{pattern}{Passed to list.files. Pattern to match/filter files.}
}
\description{
Run all the R scripts in a folder.
Author: Bryce Chamberlain.
}
\examples{
# runfolder( 'R' )
}
