% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/binbyvol.R
\name{binbyvol}
\alias{binbyvol}
\title{Bin by Volume}
\usage{
binbyvol(df, groupby, vol, numbins)
}
\arguments{
\item{df}{(Data Frame) Your data.}

\item{groupby}{(Character) Name of the column you'll create cuts in. Must be the character name of a numeric column.}

\item{vol}{(Character) Name of the column for which which each cut will have an equal percentage of volume.}

\item{numbins}{Number of bins to use.}
}
\value{
Age breakpoints returned by my function such that there is 10% of CountofPeople volume in each binned Age group.
}
\description{
Bins a numerical column according to another numerical column's volume.
For example if I want to bin a column "Age" (of people) into 10 deciles according to "CountofPeople" then I will get Age breakpoints returned by my function such that there is 10% of CountofPeople volume in each binned Age group. 
This function handles NA's as their own separate bin, and handles any special values you want to separate out.
Author: Scott Sobel. Tech Review: Bryce Chamberlain.
}
\examples{
# bin Sepal.Width according to Sepal.Length.
iris$bin <- binbyvol(iris, 'Sepal.Width', 'Sepal.Length', 5)

# check the binning success.
aggregate( Sepal.Length ~ bin, data = iris, sum )
}
