% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/easybgm.R
\name{easybgm}
\alias{easybgm}
\title{Fit a Bayesian analysis of networks}
\usage{
easybgm(
  data,
  type,
  package = NULL,
  not_cont = NULL,
  iter = 10000,
  save = FALSE,
  centrality = FALSE,
  progress = TRUE,
  ...
)
}
\arguments{
\item{data}{An n x p matrix or dataframe containing the variables for n independent observations on p variables.}

\item{type}{What is the data type? Options: continuous, mixed, ordinal, binary}

\item{package}{The R-package that should be used for fitting the network model; supports BGGM, BDgraph, and bgms. Optional argument;
default values are specified depending on the datatype. Temporarily BGGM is not supported due to issues with the package itself.}

\item{not_cont}{If data-type is mixed, a vector of length p, specifying the not-continuous
variables (1 = not continuous, 0 = continuous).}

\item{iter}{number of iterations for the sampler.}

\item{save}{Logical. Should the posterior samples be obtained (default = FALSE)?}

\item{centrality}{Logical. Should the centrality measures be extracted (default = FALSE)? Note, that it will significantly increase the computation time.}

\item{progress}{Logical. Should a progress bar be shown (default = TRUE)?}

\item{...}{Additional arguments that are handed to the fitting functions of the packages, e.g., informed prior specifications.}
}
\value{
The returned object of \code{easybgm} contains several elements:

\itemize{

\item \code{parameters} A p x p matrix containing partial associations.

\item \code{inc_probs} A p x p matrix containing the posterior inclusion probabilities.

\item \code{BF} A p x p matrix containing the posterior inclusion Bayes factors.

\item \code{structure} Adjacency matrix of the median probability model (i.e., edges with a posterior probability larger 0.5).
}

In addition, for \code{BDgraph} and \code{bgms}, the function returns:

\itemize{

\item \code{structure_probabilities} A vector containing the posterior probabilities of all visited structures, between 0 and 1.

\item \code{graph_weights} A vector containing the number of times a particular structure was visited.

\item \code{sample_graphs} A vector containing the indexes of a particular structure.
}

For all packages, when setting \code{save = TRUE} and \code{centrality = TRUE}, the function will return the following objects respectively:

\itemize{

\item \code{samples_posterior} A k x iter matrix containing the posterior samples for each parameter (i.e., k = (p/(p-1))/2) at each iteration (i.e., iter) of the sampler.

\item \code{centrality} A p x iter matrix containing the centrality of a node at each iteration of the sampler.
}
}
\description{
Easy estimation of a Bayesian analysis of networks to obtain conditional (in)dependence relations between variables in a network.
}
\details{
Users may oftentimes wish to deviate from the default, usually uninformative, prior specifications of the
packages to informed priors. This can be done by simply adding additional arguments to the \code{easybgm} function.
Depending on the package that is running the underlying network estimation, researcher can specify different prior
arguments. We give an overview of the prior arguments per package below.

\strong{bgms}:

\itemize{

\item \code{interaction_prior} prior distribution of the interaction parameters, can be either "UnitInfo" for the Unit Information prior, or "Cauchy" for the Cauchy distribution. The default is set to "UnitInfo".

\item \code{edge_prior} prior on the graph structure, which can be either "Bernoulli" or "Beta-Bernoulli". The default is "Bernoulli".

\item \code{inclusion_prior} prior edge inclusion probability for the "Bernoulli" distribution. The default is 0.5.

\item \code{beta_bernoulli_alpha} and \code{beta_bernoulli_alpha} the parameters of the "Beta-Bernoulli" distribution. The default is 1 for both.

\item \code{threshold_alpha} and \code{threshold_beta} the parameters of the beta-prime distribution for the threshold parameters. The defaults are both set to 1.

}

\strong{BDgraph}:

\itemize{

\item \code{df.prior} prior on the parameters (i.e., inverse covariance matrix), degrees of freedom of the prior G-Wishart distribution. The default is set to 2.5.

\item \code{g.prior} prior probability of edge inclusion. This can be either a scalar, if it is the same for all edges, or a matrix, if it should be different among the edges. The default is set to 0.5.

}
\strong{BGGM}:

\itemize{

\item \code{prior_sd} the standard deviation of the prior distribution of the interaction parameters, approximately the scale of a beta distribution. The default is 0.25.
}

We would always encourage researcher to conduct prior robustness checks.
}
\examples{


library(easybgm)
library(bgms)

data <- na.omit(Wenchuan)

# Fitting the Wenchuan PTSD data
\donttest{
fit <- easybgm(data, type = "continuous",
                iter = 1000 # for demonstration only (> 5e4 recommended)
                )

summary(fit)
}
\donttest{
# To extract the posterior parameter distribution
# and centrality measures

fit <- easybgm(data, type = "continuous",
                iter = 1000, # for demonstrative purposes, generally, 1e5 iterations are recommended
                save = TRUE,
                centrality = TRUE)
}
}
